package edu.ucdavis.rj;

/**
 * Contains common, useful classes for use with inni's by clause.
 */
abstract public class Common extends InniArm.By {
    // parameter position
    protected int exprPos = 0;
    public Common(int exprPos) {
	this.exprPos = exprPos;
    }

    /**
     * Do invocation selection on the {@code exprPos}'th parameter
     * in smallest order first.
     * E.g., for JR's {@code inni f(x,y,z) by y},
     * use {@code Smallest(1)}.
     */
    static public class Smallest extends Common {
	public Smallest(int exprPos) {
	    super(exprPos);
	}
	public Comparable expr(Invocation inv) {
	    return (Comparable)(inv.getParam(exprPos));
	}
	public int compareTo(Comparable o1, Comparable o2) {
	    ////System.out.println("by compareTo "+o1+" "+o2);
	    return o1.compareTo(o2);
	}

    }

    /**
     * Do invocation selection on the {@code exprPos}'th parameter
     * in largest order first.
     * E.g., for JR's {@code inni f(x,y,z) by -y},
     * use {@code Largest(1)}.
     */
    static public class Largest extends Common {
	public Largest(int exprPos) {
	    super(exprPos);
	}

	// In JR, would have expr return - and then use usual compareTo.
	// Here, though, E is Comparable and - won't always work.
	// Instead, just invert the sense of compareTo below.

	public Comparable expr(Invocation inv) {
	    return (Comparable)(inv.getParam(exprPos));
	}
	public int compareTo(Comparable o1, Comparable o2) {
	    // System.out.println("compareTo "+e1+" "+e2);
	    int result = o1.compareTo(o2);
	    // first make sure result is something we can negate
	    // (e.g., not Integer.MAX_VALUE or Integer.MIN_VALUE)
	    if (result < 0) {
		result = -1;
	    }
	    else if (result > 0) {
		result = 1;
	    }
	    return -result;
	}

    }

}
