package edu.ucdavis.rj;

/**
 *
 * Methods for creating RJ virtual machines and RJ remote objects.
 * (These interface to VM and rjvm,
 * without exposing those details to the user.)
 */
public class Create {

    /**
     * Just to prevent any confusion,
     * no need ever to instantiate.
     */
    private Create() {
    }

    /**
     * A common case of VM creation: create a new VM on the same host.
     * In JR, e.g., {@code new vm();}.
     * Invokes {@link #createVM(String)} on {@code createVM(name)}
     * where {@code name} is the name of the host on which {@code createVM}
     * is executed.
     * @return the new {@code VM}.
     */
    public static VM  createVM() {
	///////////Debug.turnOn();
	Debug.println("RJHelper createVM1");
        return createVM(rjvm.thisVM.host);
    }

    /**
     * The general case of VM creation:
     * create a new VM on the specified host.
     * In JR, e.g., {@code new vm() on "pc17";}.
     * @param onHost the name of the host on which to create the new VM.
     * @return the new {@code VM}.
     */
    public static VM createVM(String onHost) {
	//////Debug.println("RJHelper createVM2");
        return ((VM) (rjvm.createVM(onHost, rjvm.thisVM.host)));
    }

    /**
     * A common case of remote object creation:
     * create a new remote object on the same host.
     * In JR, e.g., {@code new remote X(args);}.
     * Invokes {@link #createInstance(VM,String,Object...)} on
     * {@code createInstance(name,cls,args)}
     * where {@code name} is the name of the host
     * on which {@code createInstance}
     * is executed.
     * @param cls the name of class to instantiate.
     *        (N.B., the name is a String.)
     * @param args the arguments to {@code cls}'s constructor
     * @return a {@code RemoteRefs} for the new remote object.
     */
    public static RemoteRefs createInstance(String cls, Object ... args) {
	return createInstance(VM.currentVM(), cls, args);
    }

    /////////// reminder: cls's constructor must be public
    /////// consider changing String cls to Class (user: foo.class)?
    /////// or allow either?
    /**
     * The general case of VM creation:
     * create a new VM on the specified host.
     * In JR, e.g., {@code new remote X(args) on "pc17";}.
     * @param vm the host on which to create the new instance.
     * @param cls the name of class to instantiate.
     *        (N.B., the name is a String.)
     * @param args the arguments to {@code cls}'s constructor
     * @return a {@code RemoteRefs} for the new remote object.
     */
    public static RemoteRefs createInstance(VM vm, String cls, Object ... args) {
	Class [] types = new Class [args.length];
	for (int i = 0; i < args.length; i++) {
	    types[i] = args[i].getClass();
	    Debug.println("createInstance type ="+types[i]);
	}
	Debug.println("createInstance vm.rjVM ="+vm.rjVM);
	RemoteRefs o = (RemoteRefs)
	    rjvm.createInstance(vm.rjVM, cls, types, args);
	Debug.println("createInstance back OK "+o);
	return o;
    }

    /**
     * Equivalent to JR's vm.thisvm.
     * @return The current VM.
     */
    public static VM getThisVM() {
	return VM.currentVM();
    }

    public static OpMethod newVMOpMethod = null;
    public static OpMethod newROOpMethod = null;
    public static OpProxy newVM = null;
    public static OpProxy newRO = null;
    static {
	    try {
		newVMOpMethod = new OpMethod() {
			public void codeBlock(Invocation inv) {
			    //System.out.println("newVM process");
			    String host = (String)(inv.getParam(0));
			    ////System.out.println("====newVM host="+host);
			    VM v1 = Create.createVM(host);
			    ////System.out.println("in newVM "+ (v1 == null? "NULL":"not NuLL"));
			    inv.setReturnValue(v1);
			}
		    };
		newVM = new OpProxy(newVMOpMethod);
		newROOpMethod = new OpMethod() {
			public void codeBlock(Invocation inv) {
			    //System.out.println("newVM process");
			    VM theVM = (VM)(inv.getParam(0));
			    String theClass = (String)(inv.getParam(1));
			    Invocation theInv = (Invocation)(inv.getParam(2));
			    ////System.out.println("====newRemote theClass="+theClass);
			    // basically toArray
			    // (but params is local to Invocation)
			    Object [] theParams = new Object [theInv.paramsLength()];
			    for (int k = 0; k < theInv.paramsLength(); k++) {
				theParams[k] = theInv.getParam(k);
			    }
			    RemoteRefs r1 = Create.createInstance(theVM, theClass, theParams);
			    inv.setReturnValue(r1);
			}
		    };
		newRO = new OpProxy(newROOpMethod);
	    } catch (Exception e) {
		System.err.println("'s");
		e.printStackTrace();
	    }
    }


}
