package edu.ucdavis.rj;

import java.util.*;

/**
 * Represents the elseafter arm on an inni.
 */
public class InniArmElseafter {

    long millis;
    int nanos;
    InniArmElseCode code;

    /**
     * If no suitable invocation is present
     * or arrives within the specified time,
     * then execute the code in this arm and terminate the inni.
     * The general case also specifies nanoseconds.
     * @param millis milliseconds.
     * @param nanos nanoseconds.
     * @param code the code for the arm.
     */
    public InniArmElseafter(long millis, int nanos, InniArmElseCode code) {
	this.millis = millis;
	this.nanos = nanos;
	this.code = code;
    }

    /**
     * The common case specifies only milliseconds.
     * Invokes {@link #InniArmElseafter(long,int,InniArmElseCode)}
     * on {@code millis, 0, code}.
     * @param millis milliseconds.
     * @param code the code for the arm.
     */
    public InniArmElseafter(long millis, InniArmElseCode code) {
	this(millis, 0, code);
    }

}
