package edu.ucdavis.rj;

import java.rmi.*;
import java.rmi.server.*;


/**
 * Basic operation abstraction.
 * Don't extend java.rmi.Remote!
 */
public interface Op {

    //////////// start of user visible (useful) methods:

    /**
     * Determines whether this operation is a {@code noop}.
     * @return true if and only if this operation is a {@code noop}.
     * @throws java.rmi.RemoteException if RMI fails.
     */
    public boolean isNoop() throws java.rmi.RemoteException;

    /**
     * Invoke this operation asynchronously.
     * @param originalInv The invocation to service.
     * @throws java.rmi.RemoteException if RMI fails.
     */
    public void send(Invocation originalInv) throws java.rmi.RemoteException;

    /**
     * Invoke this operation asynchronously.
     * Abbreviation for 
     *  {@code
        this.send (new Invocation(...));
	}
     * See {@link Op#send}.
     * @throws java.rmi.RemoteException if RMI fails.
     */
    public void send() throws java.rmi.RemoteException;

    /**
     * A semaphore V (aka up) operation.
     * Intended for use on {@link OpInni}'s semaphore operations.
     * @throws java.rmi.RemoteException if RMI fails.
     */
    public void V() throws java.rmi.RemoteException;

    /**
     * Invoke this operation synchronously.
     * @param  originalInv The invocation to service.
     * @return The invocation,
     * from which the return value of the operation can be extracted.
     * <P>
     * N.B., (the reference for) the returned invocation might not be the
     * same as {@code inv}.
     * For example, do <b> NOT </b> use, e.g.,
     *  {@code
        Invocation inv = new Invocation(...);
	thefun.call(inv);
        System.out.println(inv.getReturnValue());
	}
     * because {@code inv}'s value after the {@code call} will be the same
     * as its value before the call, and {@code inv.getReturnValue()} will
     * likely be {@code null}.
     * Instead, in this example, use
     *   {@code inv = thefun.call(inv);}.
     * @throws java.rmi.RemoteException if RMI fails.
     */
    public Invocation call(Invocation originalInv)
	throws java.rmi.RemoteException;

    /**
     * Invoke this operation synchronously.
     * Abbreviation for 
     *  {@code
        this.call (new Invocation(...));
	}
     * See {@link Op#call}.
     * @return The first pending invocation.
     * @throws java.rmi.RemoteException if RMI fails.
     */
    public Invocation call() throws java.rmi.RemoteException;

    /**
     * Get the first (oldest) pending invocation of this {@link OpInni}.
     * Wait if no invocation is pending.
     * (Not allowed on an {@link OpMethod}.)
     * @return The first pending invocation.
     * @throws java.rmi.RemoteException
     *         if this {@code Op} is an {@link OpMethod}.
     */
    public Invocation receive() throws java.rmi.RemoteException;

    /**
     * A semaphore P (aka down) operation.
     * Intended for use on {@link OpInni}'s semaphore operations.
     * (Not allowed on an {@link OpMethod}.)
     * @return The first pending invocation.
     * @throws java.rmi.RemoteException
     *         if this {@code Op} is an {@link OpMethod}.
     */
    public Invocation P() throws java.rmi.RemoteException;

    /**
     * Returns the number of Invocations pending for this operation.
     * @return The number of pending Invocations.
     * @throws java.rmi.RemoteException if RMI fails.
     */
    public int length() throws java.rmi.RemoteException;


    //////////// end of user visible (useful) methods.

    //////////// start of internal methods.

    /**
     * Returns unique identifier for this operation.
     * @return that id.
     * @throws java.rmi.RemoteException if RMI fails.
     */

    public String getId() throws java.rmi.RemoteException;

    /**
     * Get the timestamp of the first (oldest)
     * pending invocation of this operation.
     * @return that timestamp.
     * @throws java.rmi.RemoteException
     *         if this {@code Op} is an {@link OpMethod}.
     */
    public long getFirstTime() throws java.rmi.RemoteException;

    /**
     * Can this operation be serviced by an inni?
     * Only an {@code OpInni} can.
     * @return {@code true} if and only if this operation is an {@code OpInni}.
     * @throws java.rmi.RemoteException if RMI fails.
     */
    public boolean canAppearInInni() throws java.rmi.RemoteException;

    /**
     * Get the equivalence class lock for this operation.
     * (Not allowed on an {@link OpMethod}.)
     * @return that lock.
     * @throws java.rmi.RemoteException if RMI fails.
     */
    public InLock getLock() throws java.rmi.RemoteException;

    /**
     * Is this operation on a remote VM or on the current VM?
     * (Not allowed on an {@link OpMethod}.)
     * @param site machine name.
     * @return {@code true} if and only if this operation is remote.
     * @throws java.rmi.RemoteException if RMI fails.
     */
    public boolean isRemote(String site) throws RemoteException;

    /**
     * If operation's queue of pending invocations was locked due
     * to equivalence class locking stuff (e.g., merging),
     * then deliver pending messages.
     * @throws java.rmi.RemoteException
     *         if this {@code Op} is an {@link OpMethod}.
     */
    public void deliverPendingMessages() throws RemoteException;

    /**
     * Get an iterator to iterate over
     * pending invocations of this operation.
     * @return that iterator.
     * @throws java.rmi.RemoteException
     *         if this {@code Op} is an {@link OpMethod}.
     */
    public OpInniIterator elements()
	throws java.rmi.RemoteException;

    //////////// end of internal methods.

}
