/*
 */

package edu.ucdavis.rj;

import java.util.ListIterator;
import java.util.List;
import java.rmi.*;
import java.rmi.server.*;

public class OpInniIteratorRemoteImpl
    extends UnicastRemoteObject
    implements OpInniIteratorRemote
{
    static final long serialVersionUID = 0;
    ListIterator<Invocation> listIt;
    List<Invocation> theList;
    int index;

    public OpInniIteratorRemoteImpl(List<Invocation> theList)
	throws RemoteException
    {
	this.listIt = theList.listIterator(0);
	this.index = -1;
	this.theList = theList;
	rjvm.registerRemote(this);
    }

    public OpInniIteratorRemoteImpl()
	throws RemoteException
    {
	listIt = null;
	rjvm.registerRemote(this);
    }

    public boolean hasNext()
	throws RemoteException
    {
	return ((listIt == null) ? false : listIt.hasNext());
    }

    /////////////// keep for interentry stuff???
    public boolean hasMoreElements()
	throws RemoteException
    {
	return this.hasNext();
    }

    public Invocation next()
	throws RemoteException
    {
	if (listIt == null)
	    return null;

	this.index++;
	Invocation inv = listIt.next();
	return inv;
    }

    /////////////// keep for interentry stuff???
    public Invocation nextElement()
	throws RemoteException
    {
	return this.next();
    }

    public Invocation get(int index)
	throws RemoteException
    {
	if (theList == null)
	    return null;

	return theList.get(index);
    }


    // removes the last element returned
    public void remove()
	throws RemoteException
    {
	if (listIt != null)
	{
	    this.index--;
	    listIt.remove();
	}
    }

    /////////////// keep for interentry stuff???
    // removes the element at index
    public void remove(int index)
	throws RemoteException
    {
	if (listIt != null)
	{
	    this.theList.remove(index);
	    if (index < this.index) this.index--;
	    if (this.index >= 0)
		this.listIt = this.theList.listIterator(this.index);
	}
    }

    /////////////// keep for interentry stuff???
    public int getCurInvocationIndex()
	throws RemoteException
    {
	return this.index;
    }

    public void unregister()
    {
	rjvm.unregisterRemote(this);
    }

    public int size()
	throws RemoteException
    {
	return theList.size();
    }

    public void reset()
	throws RemoteException
    {
	this.listIt = this.theList.listIterator(0);
	this.index = -1;
    }

}
