package edu.ucdavis.rj;

import java.util.*;
import java.io.Serializable;

import java.rmi.*;


/**
 * An OpProxy acts like a capability in JR or SR terms.
 * Its methods are delegated to the remote object.
 *
 * To get an OpProxy for an OpRemote {@code f},
 * just use {@code new OpProxy(f)}.
 */
public class OpProxy
    implements java.io.Serializable, Op {

    private OpRemote impl = null;

    public OpProxy(OpRemote impl) {
	this.impl = impl;
	// cache impl's values
	try {
	    cachedImplId = impl.getId();
	    cachedImplIsNoop = impl.isNoop();
	    cachedImplHashCode = impl.hashCode();
	} catch (java.rmi.RemoteException e) {
	    e.printStackTrace();
	    System.exit(1);
	}
    }

    /**
     * Access method to return proxy's implementation.
     * @return This proxy's {@code OpRemote} implementation.
     */
    public OpRemote getOpRemote() {
	return this.impl;
    }

    // cached values from impl (since impl and those values don't change).
    // 2010-08-23 haven't assessed whether caching makes a
    // significant difference in execution time.
    // no noticeable diff for vsuite, but those tests don't
    // do intensive checking of these.
    // (and they include compilation
    //  and they use sleep instead of quiescence,
    //  so sleep dominates execution time.)
    // I guess this caching would not matter
    // for most realistic JR progams anyway.
    private String cachedImplId;
    private boolean cachedImplIsNoop;
    // see further comments under hashCode()
    private int cachedImplHashCode;

    public String getId() throws RemoteException {
        // return impl.getId();
	return cachedImplId;
    }
    
    public boolean isNoop() throws RemoteException {
        // return impl.isNoop();
	return cachedImplIsNoop;
    }

    public long getFirstTime() throws RemoteException {
        return impl.getFirstTime();
    }

    ////////////// could and should cache this??????
    public boolean canAppearInInni() throws RemoteException {
        return impl.canAppearInInni();
    }

    ////////////// could and should cache this??????
    public InLock getLock() throws RemoteException {
        return impl.getLock();
    }

    ////////////// could and should cache this??????
    public boolean isRemote(String site) throws RemoteException {
        return impl.isRemote(site);
    }

    ////////////// could and should cache this??????
    public void deliverPendingMessages() throws RemoteException {
        impl.deliverPendingMessages();
    }

    public OpInniIterator elements() throws java.rmi.RemoteException {
        return impl.elements();
    }

    public void send(Invocation inv) throws RemoteException {
	impl.send(inv);
    }
    public void send() throws RemoteException {
	impl.send();
    }
    public void V() throws RemoteException {
	impl.V();
    }
    public Invocation call(Invocation inv) throws RemoteException {
	return impl.call(inv);
    }
    public Invocation call() throws RemoteException {
	return impl.call();
    }
    public Invocation receive() throws RemoteException {
	return impl.receive();
    }
    public Invocation P() throws RemoteException {
	return impl.P();
    }
    public int length() throws RemoteException {
	return impl.length();
    }

    /**
     * Two OpProxys are equal if their OpRemotes are.
     * An OpProxy equals an OpRemote if the OpProxy's impl is the OpRemote.
     * Consistent with other equals (e.g. String.equals,
     * return false for null or a non-OpProxy and non-OpRemote object.
     * @param  other The other {@code Object} to compare.
     * @return {@code true} if and only if equal.
     */
    public boolean equals(Object other) {
	///////System.out.println("  ** OpProxy");
	if (other instanceof OpProxy) {
	    ///////System.out.println("  ** OpProxy vs OpProxy");
	    OpProxy otherOpProxy = (OpProxy)other;
	    return OpRemote.Helper.twoOpRemotesEqual(this.impl, otherOpProxy.impl);
	}
	if (other instanceof OpRemote) {
	    ///////System.out.println("  ** OpProxy vs OpRemote");
	    OpRemote otherOpRemote = (OpRemote)other;
	    return OpRemote.Helper.twoOpRemotesEqual(this.impl, otherOpRemote);
	}
	if (other == null) {
	    return false;
	}
	return false;
    }

    /********
    // force hashing to use equals.
    // not good for performance, but hard to discriminate between
    // values of OpProxy.
    // (Could give each one an Id, like OpImpl's id, just for this purpose.)
    /////////// reconsider this later...
    public int hashCode() {
	return 9999;
    }
    ***/

    // hard to discriminate between values of OpProxy themselves,
    // so use impl's value, which makes sense.
    // it's cached to make this perform better.
    public int hashCode() {
	return cachedImplHashCode;
    }

}
