package edu.ucdavis.rj;

// returned nodes are not copies
class PriorityList
{
    PNode _head, _tail;
    long els;

    public PriorityList()
    {
	this._head = this._tail = null;
	this.els = 0;
    }

    public synchronized long size()
    {
	return els;
    }

    public synchronized boolean empty()
    {
	return els == 0;
    }

    public synchronized void clear()
    {
	this._head = this._tail = null;
    }

    public synchronized Thread thread()
    {
	if (this._head == null)
	    return null;
	else
	    return this._head.thrd;
    }

    public synchronized PairBoolean getLock()
    {
	if (this._head == null)
	    return null;
	else
	    return this._head.offQueue;
    }

    public synchronized long headPriority()
    {
	if (this._head == null)
	    return 0;
	else
	    return this._head.priority;
    }

    public synchronized void removeHead()
    {
	if (this._head != null)
	{
	    els--;
	    this._head = this._head.next;
	    if (this._head == null) this._tail = null;
	    else this._head.prev = null;
	}
    }

    synchronized PNode remove(PNode node)
    {
	PNode retnode = null;
//System.out.println(els + " -> " + node + ":" + node.next + ":" + node.prev);
	if (node != null)
	{
	    if ((els == 1) || (els == 0))
	    {
		_head = _tail = null;
		retnode = null;
	    }
	    else if (node == _head)
	    {
		node.next.prev = null;
		_head = node.next;
		node.next = null;
		node.prev = null;
		retnode = _head;
	    }
	    else if (node == _tail)
	    {
		node.prev.next = null;
		_tail = node.prev;
		node.prev = null;
		retnode = null;
	    }
	    else
	    {
		node.next.prev = node.prev;
		node.prev.next = node.next;
		retnode = node.next;
		node.next = node.prev = null;
	    }
	    els--;
	}
	return retnode;
    } 

/*
    public synchronized PNode insert(long priority, Thread thrd,
	boolean isEClock)
    {
	return insert(priority, thrd, isEClock, null);
    }
*/

    public synchronized PNode insert(long priority, Thread thrd,
	boolean isEClock, PairBoolean offEntry)
    {
	PNode current;
 	PNode newnode = new PNode(priority, thrd, isEClock, offEntry);

	// start searching at the tail as my use will most likely
	// add nodes at the tail
	els++;
	if ((this._head == null) || (this._tail == null))
	{
	    this._head = this._tail = newnode;
	}
	else
	{
	    current = this._tail;
	    while ((current != null) && (current.priority > priority))
		current = current.prev;

	    if ((current != null) && (current.priority <= priority))
	    {
		// insert to the right of the current node
		newnode.next = current.next;
		newnode.prev = current;
		current.next = newnode;
		if (current == this._tail)
		    this._tail = newnode;
		else
		    newnode.next.prev = newnode;
	    }
	    else
	    {
		// this node is the new head
		newnode.next = this._head;
		this._head.prev = newnode;
		this._head = newnode;
	    }
	}

	return newnode;
    }

    public synchronized PLIterator iterator()
    {
	return new PLIterator(this._head, this);
    }
}
