package edu.ucdavis.rj;

import java.io.*;
import java.rmi.RemoteException;

public class ProxyOutputStream extends OutputStream
{
    RemoteOutputStream rout;

    public ProxyOutputStream(RemoteOutputStream rout)
    {
	this.rout = rout;
    }

    public void flush()
	throws IOException
    {
	try
	{
	    rout.flush();
	}
	catch (RemoteException e)
	{ throw new IOException("RemoteException: " + e.getMessage()); }
    }

    public void close()
	throws IOException
    {
	try
	{
	    rout.close();
	}
	catch (RemoteException e)
	{ throw new IOException("RemoteException: " + e.getMessage()); }
    }

    public void write(int b)
	throws IOException
    {
	try
	{
	    rout.write(b);
	}
	catch (RemoteException e)
	{ throw new IOException("RemoteException: " + e.getMessage()); }
    }

    public void write(byte[] buf)
	throws IOException
    {
	try
	{
	    rout.write(buf);
	}
	catch (RemoteException e)
	{ throw new IOException("RemoteException: " + e.getMessage()); }
    }

    public void write(byte[] buf, int off, int len)
	throws IOException
    {
	try
	{
	    rout.write(buf, off, len);
	}
	catch (RemoteException e)
	{ throw new IOException("RemoteException: " + e.getMessage()); }
    }
}
