package edu.ucdavis.rj;

import java.util.*;

/**
 * Mechanism by which quantifiers get set.
 */
interface Quantifiable {

    /**
     * Sets quantifiers.
     * @param  q The quantifiers.
     */
    abstract void setQuantifiers(Quantifiers q);

    /**
     * Useful method(s) for {@code Quantifiable} objects.
     * (Can't define as methods within {@code Quantifiable}
     * since that's an {@code interface}.)
     */
    class Helper {

	static void setQuantifiers(Quantifiable qf, Quantifiers quants) {
	    if (qf != null && quants != null) {
		qf.setQuantifiers(quants);
	    }
	}

    }
}
