package edu.ucdavis.rj;

import java.rmi.Remote;
import java.rmi.RemoteException;

public interface RJX extends Remote
{
    VM createVM(String onHost, String fromHost) throws RemoteException;
    VM createVM(String onHost, String fromHost, String vmType,
      Class [] vmParamType, Object [] vmParam) throws RemoteException;
    VM createVM(VM host, String fromHost) throws RemoteException;
    VM createVM(VM host, String fromHost, String vmType,
      Class [] vmParamType, Object [] vmParam) throws RemoteException;
    Object [] getParamValues(String host) throws RemoteException;
    Class [] getParamTypes(String host) throws RemoteException;
    //void hello(String host, rjvm_intf jrVM, boolean idle)
    void hello(String host, VM rjVM, boolean idle)
					throws RemoteException;
    boolean destroyVM(String host) throws RemoteException;
    void exit(int exitval) throws RemoteException;
    void registerQuiescenceAction(OpProxy opProxy) throws RemoteException,
					      QuiescenceRegistrationException; 
    //byte [] getClass(String name) throws RemoteException;
    RemoteOutputStream getStdOut() throws RemoteException;
    RemoteOutputStream getStdErr() throws RemoteException;
    RemoteInputStream getStdIn() throws RemoteException;
    InLock createRemoteLock() throws RemoteException;
    void lockEC() throws RemoteException;
    void unlockEC() throws RemoteException;

    void idle(String vmName) throws RemoteException;
    void notIdle(String vmName) throws RemoteException;
    void ping() throws RemoteException;

    final int MAX_MISSED = 2; // max number of missed pings to tolerate
}
