package edu.ucdavis.rj;

import java.io.*;
import java.rmi.RemoteException;
import java.rmi.Remote;

public interface RemoteInputStream
    extends Remote
{
    public int available()
	throws IOException, RemoteException;

    public void close()
	throws IOException, RemoteException;

    public void mark(int readlimit)
	throws RemoteException;

    public boolean markSupported()
	throws RemoteException;

    public int read()
	throws IOException, RemoteException;

    public readResult read(int len)
	throws IOException, RemoteException;

    public void reset()
	throws IOException, RemoteException;

    public long skip(long n)
	throws IOException, RemoteException;

    public static class readResult
	implements Serializable
    {
        static final long serialVersionUID = 0;
	public byte [] buf;
	public int ret;

	public readResult(int len)
	{
	    buf = new byte[len];
	}
    }
}
