package edu.ucdavis.rj;

import java.util.LinkedList;
import java.util.NoSuchElementException;

class Semaphore
{
    LinkedList<ModBoolean> waitQ;
    private int s;

    public Semaphore(int init)
    {
	this.s = init;
	this.waitQ = new LinkedList<ModBoolean>();
    }

    public void acquire()
    {
	ModBoolean mylock_continue = null;

	synchronized (this)
	{
	    if (s == 0)
	    {
		// need to wait
		mylock_continue = new ModBoolean(true);
		waitQ.addLast(mylock_continue);
	    }
	    else
	    {
		// let's go
		s--;
		return;
	    }
	}
	synchronized (mylock_continue)
	{
	    while (mylock_continue.getValue())
	    {
		try
		{
		    mylock_continue.wait();
		} catch (Exception e) { e.printStackTrace(); }
	    }
	}
    }

    
    public synchronized void release()
    {
	if (waitQ.isEmpty())
	{
	    s++;
	    return;
	}
	else
	{
	    ModBoolean itslock_continue = null;
	    try
	    {
		itslock_continue = (ModBoolean) waitQ.removeFirst();
	    }
	    catch (NoSuchElementException e)
	    {
		throw new rjRuntimeError("Unexpected empty list");
	    }
	    synchronized (itslock_continue)
	    {
		itslock_continue.setValue(false);
		itslock_continue.notifyAll();
	    }
	}
    }
}
