package edu.ucdavis.rj;

/**
 * Used to indicate that a runtime error has occurred due to
 * bad user code or an internal RJ error.
 */
public class rjRuntimeError extends Error
{
    static final long serialVersionUID = 0;

    /**
     * Create a new instance of this error.
     * @param err indicates specific problem.
     */
    public rjRuntimeError(String err)
    {
	super(err);
	// 2008-07-17 RAO
	// when such an error occurs,
	// the idle msg (notifyIdle)
        // is sent to RJX before generated code prints details.
	// there's a race between getting that printed
	// and RJX shutting down this rjvm.
	// so that the user gets *some* output for the error,
	// also print this "preview" here.
	// not ideal, but the proper fix would require some reworking of code.
	// (RJX can shutdown via Pinger (which is good for output)
	//  or Idler (Q.D.)
	//  (which often truncates output, sometimes completely).)
	System.err.println("RJ runtime error in \""
			   + Thread.currentThread().getName()
			   + "\" "
			   + this.toString()
			   + " (details below)");

	if (rjvm.thisVM != null) {
	    rjvm.thisVM.unregisterAllRemote();
	}
    }
}
