package edu.ucdavis.rj;

import java.lang.*;
import java.lang.reflect.*;
import java.rmi.*;
import java.net.*;
import java.rmi.server.*;
import java.rmi.registry.*;
import java.math.*;
import java.io.*;
import java.util.Hashtable;
import java.util.Enumeration;

public class rjvm_wrap
{
    public static ClassLoader rjl;
    private static final int NUMARGS = 8;
    private static final int SERVER_ARG = 0;
    private static final int NAME_ARG = 1;
    private static final int LOCAL_ARG = 2;
    private static final int PORT_ARG = 3;
    private static final int IMPLICIT_ARG = 4;
    private static final int VERBOSITY_ARG = 5;
    private static final int IDLE_ARG = 6;
    private static final int VMTYPE_ARG = 7;
    private static final String LOCAL_HOST = "localhost";


    private static void startmain(String [] args)
	// throws RemoteException
	throws Exception
    {
	Class classOf;
	Class [] paramtypes = {args.getClass()};
	Method maine;
	Object obj;

/*
	try
	{
*/
	    // Modify this to use specialized class loader
	    //classOf = Class.forName("edu.ucdavis.rj.rjx.rjvm",
					//true, rjvm_wrap.rjl);
	    classOf = rjvm_wrap.rjl.loadClass("edu.ucdavis.rj.rjvm");

	    maine = classOf.getMethod("main", paramtypes);
	    if (maine == null)
	    {
		throw new NoSuchMethodError("rjvm.main");
	    }
	    else if (!Modifier.isStatic(maine.getModifiers()))
	    {
		throw new NoSuchMethodError("rjvm.main not static");
	    }
	    else if (!Modifier.isPublic(maine.getModifiers()))
	    {
		throw new NoSuchMethodError("rjvm.main not public");
	    }
	    //System.out.println("calling rjvm.main");
	    Object [] actuals = {args};
	    maine.invoke(null, actuals);

	    //System.out.println("called rjvm.main");
/*
	}
	catch (Exception e)
	{ 
	    e.printStackTrace();
	    throw new RemoteException(e.toString());
	}
*/
    }

    public static void main(String args[])
    {
	if (args.length < NUMARGS)
	{
	    // System.err.println("usage: java rjvm_wrap <server host> <name> <local host> <Port> <implicitTermination> <verbosity> <idle>");
	    System.exit(1);
	}
/*
	if (System.getSecurityManager() == null)
	{
	    System.setSecurityManager(new RMISecurityManager());
	}
*/
        try
        {
	    new Socket(args[LOCAL_ARG], 0).close();
        }
        catch (NoRouteToHostException e)
        {
            System.setProperty("java.rmi.server.hostname", LOCAL_HOST);
        }
        catch (Exception e)
        {
	    // awkward silence - ignore any other exceptions since the
	    // the attempt to connect is silly anyhow
	    // -- address stand-alone laptop bug
        }
	try
	{
	    String registrySite =
	       args[SERVER_ARG].equals(args[LOCAL_ARG])
	       ? LOCAL_HOST
	       : args[SERVER_ARG];
	    //String loadername = "//" + args[SERVER_ARG] + ":" +
	    String loadername = "//" + registrySite + ":" +
			args[PORT_ARG]+"/remoteLoader";
//System.out.println("wrap: " + registrySite);
	    //Registry registry = LocateRegistry.getRegistry(registrySite,
		//Integer.parseInt(args[PORT_ARG]));
	    //RemoteLoader rl = (RemoteLoader) registry.lookup(loadername);
	    RemoteLoader rl = (RemoteLoader)Naming.lookup(loadername);
	    rjvm_wrap.rjl = new rjLoader(rl);

//System.out.println("Wrapper about to start the VM");
	    startmain(args);
	}
	catch (java.lang.reflect.InvocationTargetException e)
	{
	    System.err.println("rjvm_wrap exception: " +
		e.getTargetException().getMessage());
	    e.getTargetException().printStackTrace();
	    //System.exit(1);
	    try{
	    rjvm.rjx.exit(1);
	    }
	    catch(Exception eout)
	    {
		System.err.println("Abnormal exit!");
		eout.printStackTrace();
		System.exit(1);
	    }
	}
	catch (Exception e)
	{
	    System.err.println("rjvm_wrap exception: " + e.getMessage());
	    e.printStackTrace();
	    //System.exit(1);
	    try{
	    rjvm.rjx.exit(1);
	    }
	    catch(Exception eout)
	    {
		System.err.println("Abnormal exit!");
		eout.printStackTrace();
		System.exit(1);
	    }
	}
    }
}
