package edu.ucdavis.rj;

import java.rmi.RemoteException;
import java.rmi.*;

public interface InLock
    extends Remote
{
    // methods used by threads attempting to service an in statement
    public void lock() throws RemoteException;
    public void unlock() throws RemoteException;
    public void waitOnLock() throws RemoteException;

    // methods used by threads attempting to form an equivalence class
    public void lockEC() throws RemoteException;
    public void unlockEC() throws RemoteException;

    // methods used by InOps when messages arrive
    public boolean lock_or_register(OpRemote theop) throws RemoteException;
    public boolean innerLorR(OpRemote theop) throws RemoteException;
    public void unlockMes() throws RemoteException;

    public boolean acquireInnerLock(long mytimestamp, boolean isEClock)
	throws RemoteException;
    public void releaseInnerLock(boolean isECunlock, boolean isMesUnlock)
	throws RemoteException;
    public long waitInnerLock() throws RemoteException;
    public InLock getInnerLock() throws RemoteException;
    public LockId getLockId() throws RemoteException;
    public void forwardTo(InLock lock)
	throws RemoteException; //, LockNotHeldException;
}
