package edu.ucdavis.rj;

class PLIterator
{
    private PNode node;
    private PriorityList list;

    public PLIterator(PNode node, PriorityList list)
    {
	this.node = node;
	this.list = list;
    }

    public synchronized void remove()
    {
	node = list.remove(node);
    }

    public synchronized void next()
    {
	if (node != null)
	{
	    synchronized (list)
	    {
		node = node.next;
	    }
	}
    }

    public boolean isNull() 
    {
	return node == null;
    }

    public boolean isEC()
    {
	return node.isEClock;
    }

    public Thread thread()
    {
	return node.thrd;
    }

    public void setThread(Thread theThread)
    {
	node.thrd = theThread;
    }

    public long priority()
    {
	return node.priority;
    }

    public PairBoolean getLock()
    {
	return node.offQueue;
    }

    public void releaseFirst()
    {
	synchronized (node.offQueue)
	{
	    node.offQueue.setFirstValue(true);
	    node.offQueue.notify();
	}
    }

    public void releaseSecond()
    {
	synchronized (node.offQueue)
	{
	    node.offQueue.setSecondValue(true);
	    node.offQueue.notify();
	}
    }

    public PLIterator cloneIterator()
    {
	return new PLIterator(node, list);
    }
}
