package edu.ucdavis.rj;

import java.util.*;

/**
 * Base class for all `arms' of code, i.e., blocks for inni and co.
 */ 
abstract public class BaseArmCode {

    /**
     * Represents control flow to occur after executing ArmCode's codeBlock.
     */
    public enum Control {
	BREAK,
	CONTINUE,
	RETURN,
	NORMAL,	
    }

    /**
     * Control flow for this ArmCode.
     * More specifically, control flow is with respect to enclosing loop:
     * whether to {@code break}, {@code continue}, , {@code return},
     * or proceed normally.
     */
    private Control control;

    /**
     * Set control flow for this ArmCode to {@code control}.
     * @param control The value to set.
     */
    public void setControl(Control control) {
	this.control = control;
    }

    /**
     * Get control flow for this ArmCode.
     * @return The control flow value for this ArmCode.
     */
    public Control getControl() {
	return this.control;
    }

}
