package edu.ucdavis.rj;

import java.util.*;

import java.rmi.*;

/**
 * An operation that's to be serviced via inni.
 */
public class OpInniNonNoop extends OpInni {

    /**
     * Create a new instance of an operation that's to be serviced
     * via inni.
     * @throws java.rmi.RemoteException if RMI fails.
     */
     public OpInniNonNoop() throws RemoteException {
     }


    /**
     * Invoke this operation asynchronously.
     * @param originalInv The invocation to service.
     */
    /**
     * Internal asynchronous invocation.
     * Note that both call and send come through here.
     * This operation is not noop.
     * @param inv The invocation to service.
     * It is assumed to have already been cloned
     * and its replyOp set properly (null for send; non-null for call).
     */
    void internalSend(Invocation inv) {
	// since both send and call come through here,
	// only need to do this here.
	inv.setRJVMTimestamp();
	/////////2012-10-09	    Debug.println("sent OpInni "+this +" "+(inv.paramsLength()>0?inv.getParam(0):-99999999));

	synchronized (this) {
	    synchronized (this.waitList) {
		this.waitList.add(inv);
	    }
	}
	try {
	    boolean lockp = this.theLock.lock_or_register(this);
	    synchronized (this) {
		if(lockp) { // this inOp successfully locked the equiv. class
		    synchronized (this.waitList) {
			synchronized (this.msgList) {
			    while (this.waitList.size() != 0) {
				this.msgList.add(this.waitList.remove(0));
			    }
			}
		    }
		}
	    }
	    if(lockp) {
		// awaken a waiting process (pass the baton)
		this.theLock.unlockMes();
	    }
	} catch (java.rmi.RemoteException e) {
	    throw new rjRuntimeError("RJ internal error: OpInni.internalSend");
	}


	///////////////// how easy (but wrong) this used to be ;-)
	/************
	synchronized(lock) {
	    list.add(inv);
	    lock.notifyAll(); // awaken any receivers
	}
	**********/
    }

}
