package edu.ucdavis.rj;

import java.util.*;

/**
 * An operation that's to be serviced via a method.
 * (Aka Proc-Op.)
 * Extend this class with one that contains actual code.
 */
abstract public class OpMethod extends OpImpl {

    static final long serialVersionUID = 0;

    /**
     * Create a new instance of an operation that's to be serviced
     * via a method.
     * @throws java.rmi.RemoteException if RMI fails.
     */
     public OpMethod() throws java.rmi.RemoteException {
     }


    /**
     * Instantiate an {@code OpMethod}.
     * This method just calls the appropriate constructor,
     * but hides the {@code java.rmi.RemoteException}.
     * @return The new instance of the {@code OpMethod}.
     */
    /************8
OOPS .. of course can't do this.  OpMethod is abstract ;-(

    public static OpInni newOpMethod() {
	OpInni ret = null;
	try {
	    ret = new OpMethod();
	} catch (java.rmi.RemoteException e) {
            throw new rjRuntimeError("RJ internal error: "OpMethod.newOpMethod");
	    e.printStackTrace();
	    System.exit(1);
	}
	return ret;
    }
    *************/

    /**
     * Internal asynchronous invocation.
     * Note that both call and send come through here.
     * @param inv The invocation to service.
     * It is assumed to have already been cloned
     * and its replyOp set properly (null for send; non-null for call).
     */
    void internalSend(Invocation inv) {
	// since both send and call come through here,
	// only need to do this here.
	inv.setRJVMTimestamp();
	rjvm.threadBirth();
	//// 2012-10-10 Debug.println("sent");
	(new Thread(new T1(inv))).start();
    }

    /**
     * Override this method
     * with the actual code for the operation.
     * @param inv The invocation to service.
     */
    abstract public void codeBlock(Invocation inv);

    class T1 implements Runnable {
	Invocation inv;
	public T1(Invocation inv) {
	    this.inv = inv;
	}
	public void run() {
	    // codeBlock can throw exception,
	    // e.g., for initializing sem with negative number.
	    // need to catch and have rjvm know so it can terminate cleanly.
	    try {
		// OpProxy myBack = new OpProxy(new OpInni());
		// System.out.println("ZYX "+ ThreadLocalReplyOp.get());
		codeBlock(inv);
		inv.replyToInvoker();
	    }  catch (Exception e) {
		e.printStackTrace();
		throw new rjRuntimeError(e.toString());
	    }
	    finally {
		rjvm.threadDeath();
	    }
	}
    }

    // documentation inherited
    public Invocation receive() {
	throw new rjRuntimeError("can't receive from an OpMethod");
    }

    // documentation inherited
    public long getFirstTime() {
	throw new rjRuntimeError("RJ internal error: "+
				 "can't getFirstTime() from an OpMethod");
    }

    // documentation inherited
    public boolean canAppearInInni()
	throws java.rmi.RemoteException {
	return false;
    }


    // documentation inherited
    public synchronized InLock getLock()
	throws java.rmi.RemoteException {
	throw new rjRuntimeError("RJ internal error: "+
				 "can't getLock() from an OpMethod");
    }

    // documentation inherited
    public boolean isRemote(String site) throws java.rmi.RemoteException {
	throw new rjRuntimeError("RJ internal error: "+
				 "can't isRemote() from an OpMethod");
    }

    // documentation inherited
    public void deliverPendingMessages() throws java.rmi.RemoteException {
	throw new rjRuntimeError("RJ internal error: "+
				 "can't deliverPendingMessages() from an OpMethod");
    }

    // documentation inherited
    public OpInniIterator elements()
	throws java.rmi.RemoteException {
	throw new rjRuntimeError("RJ internal error: "+
				 "can't elements() from an OpMethod");
    }

    // documentation inherited
    public Invocation P() {
	throw new rjRuntimeError("can't P on an OpMethod");
    }

    /**
     * Returns the number of Invocations pending for this operation.
     * @return The number of pending Invocations,
     * which will be 0 for an OpMethod.
     */
    public int length() {
	return 0;
    }
}
