package edu.ucdavis.rj;

import java.util.*;
import java.io.Serializable;

import java.rmi.*;

/**
 * Adds 'remoteness' to Op.
 * It just inherits methods from Op and java.rmi.Remote.
 */
public interface OpRemote
    extends Remote, Op {

    /**
     * Useful method(s) for {@code OpRemote} objects.
     * (Can't define as methods within {@code OpRemote}
     * since that's an {@code interface}.)
     */
    public static class Helper {

	/**
	 * Compares for equality two {@code OpRemote} objects:
	 * both are {@code noop} or both have same unique operation id.
	 * @param a the first object.
	 * @param b the second object.
	 * @return {@code true} if and only if the two objects are equal.
	 */
	static boolean twoOpRemotesEqual(OpRemote a, OpRemote b) {
	    try {
		// note: these invocations isNoop() and getId might be RMIs.
		// so written to
		// -- do most common (I think) test first
		//    (seeing whether an op is noop)
		// -- avoid unnecessary invocations.
		//    (although those might be optimized anyway.)
		if (a.isNoop()) {
		    return b.isNoop();
		}
		return a.getId().equals(b.getId());
	    } catch (java.rmi.RemoteException e) {
		e.printStackTrace();
		System.exit(1);
		return false; // hush javac
	    }
	}

    }
}
