package edu.ucdavis.rj;

import java.io.Serializable;

class Timestamp
   implements Serializable, Comparable
{
    static final long serialVersionUID = 0;
    private long timestamp;

    Timestamp(long timestamp)
    {
	this.timestamp = timestamp;
    }

    public boolean equals(Object inv)
    {
	if ((inv != null) && (inv instanceof Timestamp))
	{
	    return this.timestamp == ((Timestamp)inv).timestamp;
	}
	return false;
    }

    public int compareTo(Timestamp inv)
    {
	long tmp = this.timestamp - inv.timestamp;
	return (tmp < 0) ? -1 : ((tmp > 0) ? +1 : 0);
    }

    public int compareTo(Object obj) throws ClassCastException
    {
	Timestamp inv = (Timestamp) obj;
	return this.compareTo(inv);
    }

    public long getTimestamp()
    {
	return this.timestamp;
    }

    public String toString()
    {
	return ""+this.timestamp;
    }
}
