package edu.ucdavis.rj;

import java.io.*;
import java.rmi.RemoteException;
import java.rmi.server.*;

public class RemoteInputStream_impl
    extends UnicastRemoteObject
    implements RemoteInputStream
{
    static final long serialVersionUID = 0;
    InputStream in;

    public RemoteInputStream_impl(InputStream in)
	throws RemoteException
    {
	this.in = in;
    }

    public int available()
	throws IOException, RemoteException
    {
	return in.available();
    }

    public void close()
	throws IOException, RemoteException
    {
	in.close();
    }

    public void mark(int readlimit)
	throws RemoteException
    {
	in.mark(readlimit);
    }

    public boolean markSupported()
	throws RemoteException
    {
	return in.markSupported();
    }

    public int read()
	throws IOException, RemoteException
    {
	return in.read();
    }

    public RemoteInputStream.readResult read(int len)
	throws IOException, RemoteException
    {
	RemoteInputStream.readResult result =
		new RemoteInputStream.readResult(len);
	result.ret = in.read(result.buf);
	return result;
    }

    public void reset()
	throws IOException, RemoteException
    {
	in.reset();
    }

    public long skip(long n)
	throws IOException, RemoteException
    {
	return in.skip(n);
    }
}
