/*
 * @(#)jrLoader.java                1.00 05/09/30
 *
 * jrLoader
 */

package edu.ucdavis.rj;

import java.lang.*;
import java.rmi.*;
import java.io.*;

public class rjLoader extends ClassLoader
{
    private RemoteLoader rload;
    public rjLoader(RemoteLoader rload)
    {
	this.rload = rload;
    }

    public Class loadClass(String name)
	throws ClassNotFoundException
    {
	return loadClass(name, false);
    }

    public synchronized Class loadClass(String name, boolean resolve)
	throws ClassNotFoundException
    {
	Class theClass;

	//System.out.println("Loading : " + name);
	try
	{
	    // Have I loaded it before?
	    theClass = findLoadedClass(name);
//System.out.println("Found loaded class?  " + (theClass != null));
	    if (theClass == null)
	    {
		//if (name.equals(rjvm.classname))
		//    theClass = getParent().loadClass(name);
		if (theClass == null)
		{
		    // attempt to load from the vm
		    //System.err.println("Let's ask main");
		    try
		    {
			byte [] buf = this.rload.getClass(name);
			if (buf == null)
			{
			    theClass = null;
			}
			else
			{
			    theClass = defineClass(name, buf, 0, buf.length);
			}
		    } catch (Exception e) { theClass = null; }
		    //System.err.println("main replied");

		    if (theClass == null)
		    {
			//System.err.println("main didn't know: " + name);
			// maybe it's a system class
			theClass = findSystemClass(name);
		    }
		}
	    }

	    if (resolve)
	    {
		//System.err.println("Resolving: " + name);
		resolveClass(theClass);
	    }
	    return theClass;
	} catch(Exception e)
	{ throw new ClassNotFoundException(e.toString()); }
    }
/*
    public Class findClass(String name)
	throws ClassNotFoundException
    {
	Class theClass;

	//System.out.println("Loading : " + name);
	try
	{
	    byte [] buf = this.rload.getClass(name);
	    theClass = defineClass(null, buf, 0, buf.length);
	    return theClass;
	} catch(Exception e)
	{ throw new ClassNotFoundException(e.toString()); }
    }
*/
}
