package edu.ucdavis.rj;

import java.lang.*;
import java.lang.reflect.*;
import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.*;
import java.math.*;
import java.io.*;
import java.util.Hashtable;
import java.util.Enumeration;

public class rjvm
  extends UnicastRemoteObject
  implements rjvm_intf
{
    static final long serialVersionUID = 0;
    private String name;
    public static String vmName;
    public String host;
    public static RJX rjx;
    public static rjvm thisVM;

    public static boolean threadLocalRO;

    //private static ClassLoader rjl;
    private static Hashtable<UnicastRemoteObject, UnicastRemoteObject> remTable
        = new Hashtable<UnicastRemoteObject, UnicastRemoteObject>();

    private Thread pChecker, reaper;
    private Object dieMutex;
    private boolean dying = false;
    private static Semaphore termination = new Semaphore(1);
    public static boolean implicitTermination = false;
    private static int verbosity = 0;

    private static final int NUMARGS = 8;
    private static final int SERVER_ARG = 0;
    private static final int NAME_ARG = 1;
    private static final int LOCAL_ARG = 2;
    private static final int PORT_ARG = 3;
    private static final int IMPLICIT_ARG = 4;
    private static final int VERBOSITY_ARG = 5;
    private static final int IDLE_ARG = 6;
    private static final int VMTYPE_ARG = 7;
    private static final String LOCAL_HOST = "localhost";

    protected rjvm(String name, String host) throws RemoteException
    {
Debug.println("this is   RJ  rjvm Name: " + name);
Debug.println("this is   RJ  rjvm Host: " + host);
	this.name = name;
	this.host = host;
	this.dieMutex = new Object();
	this.pChecker = new PingChecker();
	this.pChecker.start();
	this.reaper = new Reaper();
	this.reaper.start();
    }

    public String getName()
    {
	return this.name;
    }

    public String getHost()
    {
	return this.host;
    }

    public void destroyVM() throws RemoteException
    {
	synchronized (this.dieMutex)
	{
	    this.dying = true;
	    this.dieMutex.notify();
	    return;
	}
    }

    protected void die()
    {
      // the following is an attempt to "cleanly" exit the vm by
      // unexporting all of the remote objects that had been created
      // on this vm -- unfortunately, for whatever reason, this sometimes
      // leads to the vm not actually stopping
      try
      {
	boolean b = true;
//System.out.println("\t\tUnexporting others");
//System.out.println("\t\tElements: " + remTable.size());
	for (Enumeration remotes = remTable.elements();
	     remotes.hasMoreElements();)
	{
//System.out.println("\t\tAbout to unexport a remote object");
	    try
	    {
		b &= UnicastRemoteObject.unexportObject(
			(UnicastRemoteObject)remotes.nextElement(), true);
//System.out.println("\t\tUnexported a remote object");
	    } catch (Exception e)
	    { b = false; }
	}
//System.out.println("\t\tUnexporting self");
	try
	{
	    b &= UnicastRemoteObject.unexportObject(this, true);
	}
	catch (NoSuchObjectException e)
	{ }
/*
	if (!b)
	    throw new RemoteException("Cannot unexport rjvm on " + this.name);
*/
//System.out.println("\t\tVM exiting");
//System.out.println("\t\tClosing printStreams");
	//try
	//{
	    // System.out.close();
	    // System.err.close();
	//} catch (Exception ioe) { /* ignore */ }
      }
      finally
      {
	System.exit(0);
      }
    }

    public static RemoteRefs createInstance(rjvm_intf vm, String cls,
      Class [] types, Object [] args)
    {
      try {
         return vm.innerCreateInstance(cls, types, args);
      } catch (RemoteException e)
      { throw new rjCommunicationException(e); }
    }
    public RemoteRefs innerCreateInstance(String cls, Class [] types,
      Object [] args)
      throws RemoteException
    {
	Class classOf;
	Constructor constr;
	Object obj;

Debug.println("Let's create an instance of " + cls);

	Debug.println("Try to create an object: " + cls);
	Debug.println("====>>>>start createInstance "+ready);
	try
	{
	    // In JR code, loadClass(cls) always works
	    // (assuming the JR compiler generated the right types).
	    // In RJ, that can fail since the types might be wrong
	    // because the user messed up
	    classOf = rjvm.class.getClassLoader().loadClass(cls);

	} catch(Exception e)
	{ 
	    throw new RemoteException(e.toString());
	}

	Debug.println("Creating an object: " + cls);
	try {
	    // In JR code, getConstructor(types) always works
	    // (assuming the JR compiler generated the right types).
	    // In RJ, that can fail since the types might be wrong
	    // because the user messed up
	    // (or need exact match, etc. -- see comments on tryHarder).
	    try {
		constr = classOf.getConstructor(types);

		/* this is where we actually create the instance
		   - but we need to pretend that we're creating
		   a new thread as well in case the constructor
		   uses operations - this "new thread" exists
		   for the duration of the constructor
		*/
		Debug.println("getConstructor succeeded");
		Debug.println("trying newInstance");
		this.threadBirth();
		obj = constr.newInstance(args);
		Debug.println("newInstance succeeded");
	    } catch (java.lang.NoSuchMethodException e) {
		Debug.println("NoSuchMethod failed");
		Debug.println("====>>>> going to try harder");
		this.threadBirth();
		obj = tryHarder(cls, types, args);
		Debug.println("====>>>> trying harder worked");
	    }
	    /* kill the imaginary thread */
	    this.threadDeath();
	    Debug.println("Created an object: " + cls);
	} catch(Exception e)
	{ 
	    /* kill the imaginary thread */
	    this.threadDeath();
	    /// e.printStackTrace();
	    throw new RemoteException(e.toString());
	}
	finally {
	    Debug.println("====>>>>done  createInstance "+ready);
	}

	try
	{
/*
	    //System.out.println("Trying to get field");
	    Field field = classOf.getField("rjresref");
	    //if (field == null)
		//System.out.println("cannot find field");
	    //else
		//System.out.println("Got field");
	    Object f = field.get(obj);
	    //System.err.println("Got value");
	    //if (f == null)
		//System.err.println("The value is null");
	    return f;
*/
/****
	    //System.out.println("Trying to get method");
	    Method method = classOf.getMethod("RJgetrjresref");
	    //if (field == null)
		//System.out.println("cannot find method");
	    //else
		//System.out.println("Got method");
	    Object f = method.invoke(obj);
	    //System.err.println("Got value");
	    //if (f == null)
		//System.err.println("The value is null");
	    return f;
****/
	    Debug.println("Trying to get RemoteRefs for "+classOf);
	    return new RemoteRefs(classOf, obj);
	}
	catch (Exception e)
	{
	    e.printStackTrace();
	    return null;
	}
    }

    // problem: RJ doesn't have accurate types of constructors,
    // just types of the arguments.
    // (in JR, compiler figures out those types.)
    // so calling a constructor with an arg that needs wrapping or unwrapping
    // or that is a supertype of actual arg doesn't work.
    //
    // e.g.,
    //
    // suppose A has constructor
    //
    //    A(int x) {...}
    //
    // then
    //
    //    createInstance("A", 3)
    //
    // doesn't work because RJ makes Objects out of its args
    // (so the arg is actually "new Integer(3)") and
    //
    //  Class's getConstructor()
    //
    // requires an exact match of types (and int doesn't match Integer).
    //
    // similar problem with Ops vs. OpInni, etc.
    //
    // idea: see if any constructor works.
    // (since newInstance handles wrapping/unwrapping and supertypes.)
    // approach: just try each in turn.
    // if one works, great.
    // if all fail, then tough luck.
    // could instead analyze args and see whether wrapping or unwrapping
    // and whether supertype, etc.
    // but that would take a bit of effort, so this approach seems simpler.
    // also, typically, only a few constructors in a class,
    // so not too expensive to try all.
    // (could do quick arity check, but this is still simpler.)
    static private Object tryHarder(String cls, Class [] types,
				   Object [] args) 
    throws Exception {

        Class classOf;
        Object obj = null;

        //System.out.println("Let's create an instance of " + cls);
        //System.out.println("Try to create an object: " + cls);

        try {
            classOf = Class.forName(cls);
        } catch (java.lang.ClassNotFoundException e) {
	    // shouldn't happen here
	    // (since would have failed before in calling code)
            System.out.println("ClassNotFound failed OOPS");
            e.printStackTrace();
	    throw e;
        }

	Constructor<?>[] constructors = classOf.getConstructors();

	for (Constructor constructor: constructors) {

            try {
                obj = constructor.newInstance(args);
		// if it works, we're happy!
		return obj;
            } catch (java.lang.IllegalArgumentException e) {
		// do nothing: just continue loop.
		Debug.println("java.lang.IllegalArgumentException failed");
	    } catch (Exception e) {
		// these shouldn't happen.
		// System.out.println("InstantiationException failed");
		// System.out.println("IllegalAccessException failed");
		// System.out.println("IllegalAccessException failed");
                // System.out.println("InvocationTargetException failed");
		throw e;
            }
        }
        // none worked so we're not happy...
	throw new java.lang.NoSuchMethodException("can't find matching constructor");
    }



    public static Object createInstance(rjvm_intf vm, String cls,
      Class [] types, Object [] args, String binclass)
    {
      try {
         return vm.innerCreateInstance(cls, types, args, binclass);
      } catch (RemoteException e)
      { throw new rjCommunicationException(e); }
    }
    public Object innerCreateInstance(String cls, Class [] types,
      Object [] args, String binclass)
      throws RemoteException
    {
	Class classOf;
	Constructor constr;
	Object obj;

	//System.out.println("Try to create an object: " + cls);
	try
	{
	    //classOf = Class.forName(cls, true, rjvm.rjl);
	    //classOf = Class.forName(cls);
	    classOf = rjvm.class.getClassLoader().loadClass(cls);

	    constr = classOf.getConstructor(types);

	    /* this is where we actually create the instance
		- but we need to pretend that we're creating
		a new thread as well in case the constructor
		uses operations - this "new thread" exists
		for the duration of the constructor
		- this isn't strictly necessary here since
		this constructor is for binary objects, but
		let's be optimistic that such support might
		be included some day
		- if nothing else, this is here for
		symmetry/completeness
	    */
	    this.threadBirth();
	    obj = constr.newInstance(args);
	    /* kill the imaginary thread */
	    this.threadDeath();

	    //System.out.println("Created an object: " + cls);
	} catch(Exception e)
	{ 
	    /* kill the imaginary thread */
	    this.threadDeath();
	    e.printStackTrace();
	    throw new RemoteException(e.toString());
	}

	try
	{
	    // Create binary proxy object to return as rjresref
	    //System.out.println("Trying to create binary proxy");
	    //classOf = Class.forName(binclass, true, rjvm.rjl);
	    //classOf = Class.forName(binclass);
	    classOf = rjvm.class.getClassLoader().loadClass(binclass);

	    obj = classOf.newInstance();

	    //if (obj == null)
		//System.out.println("The value is null");
	    //else
	        //System.out.println("Created an object: " + binclass);
	    return obj;
	}
	catch (Exception e)
	{
	    e.printStackTrace();
	    return null;
	}
    }

    private static void startmain(String [] args)
	// throws RemoteException
	throws Exception
    {
	Class classOf;
	Class [] paramtypes = {args.getClass()};
	Method maine;
	Object obj;
	String [] theargs = new String[args.length - 1];
	System.arraycopy(args, 1, theargs, 0, theargs.length);

	amIdle = false; // main vm isn't actually idle at birth
	threadBirth();
/*
	try
	{
*/
	    // Modify this to use specialized class loader
	    //classOf = Class.forName(args[0], true, rjvm.rjl);
	    //classOf = Class.forName(args[0]);
	    classOf = rjvm.class.getClassLoader().loadClass(args[0]);

	    maine = classOf.getMethod("main", paramtypes);
	    if (maine == null)
	    {
		throw new NoSuchMethodError("main");
	    }
	    else if (!Modifier.isStatic(maine.getModifiers()))
	    {
		throw new NoSuchMethodError("main not static");
	    }
	    else if (!Modifier.isPublic(maine.getModifiers()))
	    {
		throw new NoSuchMethodError("main not public");
	    }
	    Object [] actuals = {theargs};
	    maine.invoke(null, actuals);
	    threadDeath();

	    //System.out.println("called main");
/*
	}
	catch (Exception e)
	{ 
	    e.printStackTrace();
	    throw new RemoteException(e.toString());
	}
*/
    }

    // RAO 2010-04-30
    // no need for this anymore
    //
    // it was called from 3 places: 
    // innerCreateInstance (both)
    //   main for user-defined VM
    //
    // also got rid of rjShort, rjInt, etc. classes. (in this directory).
    // eventually delete this comment (and see previous version if need to)
    /******
    private static Class [] convertTypes(Class [] types)
    {...}
    ******/

    /**
     * @param args the VM args ...
     */
    public static void main(String args[])
    {
	if (args.length < NUMARGS)
	{
	    // System.err.println("usage: java rjvm <server host> <name> <local host> <Port> <implicitTermination> <verbosity> <idle> <vmtype>");
	    System.exit(1);
	}
/*
	if (System.getSecurityManager() == null)
	{
	    System.setSecurityManager(new RMISecurityManager());
	}
*/
	try
	{
	    implicitTermination = Integer.parseInt(args[IMPLICIT_ARG]) == 1;
	    verbosity = Integer.parseInt(args[VERBOSITY_ARG]);
	    String myname = args[NAME_ARG]; 
	    String registrySite =
	       args[SERVER_ARG].equals(args[LOCAL_ARG])
	       ? LOCAL_HOST
	       : args[SERVER_ARG];
	    //String servername = "//" + args[SERVER_ARG] + ":" +
	    String servername = "//" + registrySite + ":" +
				args[PORT_ARG] + "/RJX";
//System.out.println(servername);

	    // Before any rmi stuff, make sure the hostname is set correctly
	    System.setProperty("java.rmi.server.hostname", args[LOCAL_ARG]);

	    //Registry registry = LocateRegistry.getRegistry(registrySite,
		//Integer.parseInt(args[PORT_ARG]));
	    //RJX rjx = (RJX) registry.lookup(servername);
	    RJX rjx = (RJX)Naming.lookup(servername);
	    rjvm.rjx = rjx;
	    //rjvm.rjl = new rjLoader(rjvm.rjx);

	    System.setIn(new ProxyInputStream(rjx.getStdIn()));
	    System.setOut(new AtomicPrintlnPrintStream(
			new ProxyOutputStream(rjx.getStdOut())));
	    System.setErr(new AtomicPrintlnPrintStream(
			new ProxyOutputStream(rjx.getStdErr())));
//System.out.println(vmName + " -- implicitTermination == " + implicitTermination);

	    // 2012-12-18
	    // environment options:
	    //    RJnewRO -- create new reply operation on each call invocation
	    //               or, default, use existing thread local one.
	    // set via using the magic RJJO option
	    //   setenv RJJO -DRJnewRO=1
	    // (reminder: need to pass as arg to java;
	    //  can't just have rjvm read RJnewRO directly from env.
	    //  since it's not there.)
            String RJnewRO = System.getProperty("RJnewRO");
	    threadLocalRO = (RJnewRO == null);
	    ///System.out.println("RJnewRO="+RJnewRO+" sets="+threadLocalRO);

            VM proxy;
	    rjvm_intf rjVM;
            rjvm.vmName = myname;
            if (args[VMTYPE_ARG].equals("VM"))
            {
               // regular vm
               rjVM = new rjvm(myname, args[LOCAL_ARG]);
               proxy = new VM(args[NAME_ARG], rjVM);
            }
            else
            {
               // user-defined vm
               Class classOf = Class.forName(args[VMTYPE_ARG]);
               Constructor pvm =
                  classOf.getConstructor(rjx.getParamTypes(args[NAME_ARG]));
               rjVM = (rjvm)pvm.newInstance(rjx.getParamValues(args[NAME_ARG]));
               proxy = createVMProxy(args[VMTYPE_ARG], args[NAME_ARG], rjVM);
            }
            rjvm.thisVM = (rjvm)rjVM;

// uncomment for vm object
//            VM.thisvm = proxy;

	    //Naming.rebind(myname, rjVM);
Debug.println("about to say hi");
	    rjx.hello(args[NAME_ARG], proxy, //rjVM,
			Integer.parseInt(args[IDLE_ARG]) == 1);
Debug.println("\t\t**** rjvm running *****");
	    if (args.length > NUMARGS)
	    {
		Debug.println(" rjvm args.length=="+args.length);
		String [] margs = new String[args.length - NUMARGS];
		System.arraycopy(args, NUMARGS, margs, 0, margs.length);
		startmain(margs);
		Debug.println(" back from startmain rjvm args.length=="+args.length);
	    }
	}
	catch (java.lang.reflect.InvocationTargetException e)
	{
	    System.err.println("RJ rjvm 466  exception: " +
		e.getTargetException().getMessage());
	    e.getTargetException().printStackTrace();
	    //System.exit(1);
	    try{
	    rjvm.rjx.exit(1);
	    }
	    catch(Exception eout)
	    {
		System.err.println("Abnormal exit!");
		eout.printStackTrace();
		System.exit(1);
	    }
	}
	catch (Exception e)
	{
	    System.err.println("rjvm exception: " + e.getMessage());
	    e.printStackTrace();
	    //System.exit(1);
	    try{
	    rjvm.rjx.exit(1);
	    }
	    catch(Exception eout)
	    {
		System.err.println("Abnormal exit!");
		eout.printStackTrace();
		System.exit(1);
	    }
	}
    }

    private static VM createVMProxy(String vmType, String hostname,
       rjvm_intf vm)
    {
       try
       {
          Class classOf = Class.forName("RJ" + vmType);
          Constructor ctr = classOf.getConstructor(
             new Class[] {String.class, rjvm_intf.class});
          return (VM)(ctr.newInstance(new Object [] {hostname, vm}));
       }
       catch (Exception e)
       {
          e.printStackTrace();
          System.exit(1);
          return null;
       }
    }

    public static void registerRemote(UnicastRemoteObject rem)
    {
	remTable.put(rem, rem);
	//System.out.println("registering a remote object: " + remTable.size());
    }

    public static void unregisterRemote(UnicastRemoteObject rem)
    {
	remTable.remove(rem);
	//System.out.println("removing a remote object: " + remTable.size());
    }

    public void unregisterAllRemote()
    {
	for (Enumeration remotes = remTable.elements();
	     remotes.hasMoreElements();)
	{
	    //System.out.println("\t\tAbout to unexport a remote object");
	    try
	    {
		UnicastRemoteObject.unexportObject(
			(UnicastRemoteObject)remotes.nextElement(), true);
		//System.out.println("\t\tUnexported a remote object");
	    } catch (Exception e)
	    { e.printStackTrace(); }
	}
	try
	{
	    UnicastRemoteObject.unexportObject(this, true);
	} catch (Exception e)
	{ e.printStackTrace(); }
    }

    private static long timestamp = 0;
    private static final long time_inc = 1;
    public static synchronized long getTimestamp()
    {
	return ++timestamp;
    }

    public static synchronized long setTimestamp(long ts)
    {
	timestamp++;
	if ((ts + time_inc) > timestamp)
	    timestamp = ts + time_inc;
	return timestamp;
    }


    private boolean pinged = true;
    private int missed = 0;  // number of missed pings

    // RJX periodically pings each VM to ensure that one has not
    //   quietly died
    // This method simply records the fact that it has been pinged
    final public void ping() throws RemoteException
    {
	synchronized(this)
	{
	    pinged = true;
	    missed = 0;
	}
    }

    private void checkPing()
    {
	boolean localping = false;
	synchronized(this)
	{
	    localping = pinged;
	    pinged = false;
	}
	if (!localping)
	{
	    missed++;
	}
	// one last attempt
	try
	{
	    rjx.ping();
	    missed = 0;
	}
	catch (Exception ignore)
	{}
	if (missed > RJX.MAX_MISSED)
	{
	    // It seems that RJX must be dead
	    System.err.println("Abnormal exit -- heartbeat failed!");
	    System.exit(1);
	}
    }

    private class PingChecker extends java.lang.Thread
    {
	final int SLEEP_TIME = RJX_impl.PING_SLEEP_TIME;
	public void run()
	{
	    while (true)
	    {
		try
		{
		    Thread.sleep(SLEEP_TIME);
		}
		catch (Exception e)
		{ }
		if (dying)
		{
		    break;
		}
		
		checkPing();
	    }
	}
    }

    private class Reaper extends java.lang.Thread
    {
	final int SLEEP_TIME = 50;
	public void run()
	{
	    synchronized (dieMutex)
	    {
		while (!dying)
		{
		    try
		    {
			dieMutex.wait();
		    }
		    catch (Exception e)
		    {}
		}
		
		try
		{
		    Thread.sleep(SLEEP_TIME);
		}
		catch (Exception e)
		{}
		die();
	    }
	}
    }

    private static long ready = 0, messages = 0;
    private static boolean amIdle = true;

    public static final void threadBirth()
    {
	if (!implicitTermination) return;  // don't bother if not implicit

	rjvm.termination.acquire();
	threadBirth_internal();
	rjvm.termination.release();
    }

    private static final void threadBirth_internal()
    {
	ready++;
	///Debug.println("tB_i "+ vmName + ": " + ready + " ready; " + messages + " messages");

	//System.out.println(vmName + ": " + ready + " ready -- " + messages + " messages");
	notifyNotIdle();
	//Thread.dumpStack();
    }

    public static final void threadDeath()
    {
	if (!implicitTermination) return;  // don't bother if not implicit

	rjvm.termination.acquire();
	threadDeath_internal();
	rjvm.termination.release();
    }
    private static final void threadDeath_internal()
    {
	ready--;
	///Debug.println("tD_i "+vmName + ": " + ready + " ready; " + messages + " messages");
	//System.out.println(vmName + ": " + ready + " ready -- " + messages + " messages");
	notifyIdle();
        //Thread.dumpStack();
    }

    private static final void messageSent()
    {
	messages++;
	//System.out.println(vmName + ": " + messages + " messages");
        //Thread.dumpStack();
    }

    private static final void messageReceived()
    {
	messages--;
	//System.out.println(vmName + ": " + messages + " messages");
        //Thread.dumpStack();
    }

    public static final void sendAndDie()
    {
//System.out.println("\t\t\tDIE: " + implicitTermination + " : " + vmName);
	if (!implicitTermination) return;  // don't bother if not implicit

	rjvm.termination.acquire();
	messageSent();
	threadDeath_internal();
	//System.out.println(vmName + ": --------------------");
	rjvm.termination.release();
    }

    public static final void ariseAndReceive()
    {
//System.out.println("\t\t\tARISE: " + implicitTermination + " : " + vmName);
	if (!implicitTermination) return;  // don't bother if not implicit

	rjvm.termination.acquire();
	messageReceived();
	threadBirth_internal();
	//System.out.println(vmName + ": --------------------");
	rjvm.termination.release();
    }

    private static final void notifyNotIdle()
    {
	amIdle = false;
	// 2008-03-28 RAO
	// been here forever, surprising didn't find earlier
	// if (amIdle && (ready == 1))
	if (ready == 1)
	{
	    try
	    {
		rjvm.termination.release();
		try
		{
//System.out.println("notify not idle: " + vmName);
		    rjx.notIdle(vmName);
		}
		finally
		{
		    rjvm.termination.acquire();
		}
	    }
	    catch (Exception e)
	    {
		System.err.println("notifyNotIdle cannot reach RJX ... exiting!");
		System.exit(1);
	    }
	}
    }

    private static final void notifyIdle()
    {
	if (ready == 0)
	{
	    amIdle = true;
	    try
	    {
		rjvm.termination.release();
		try
		{
//System.out.println("notify idle: " + vmName);
		    rjx.idle(vmName);
		}
		finally
		{
		    rjvm.termination.acquire();
		}
	    }
	    catch (Exception e)
	    {
		System.err.println("notifyIdle cannot reach RJX ... exiting!");
		System.exit(1);
	    }
	}
    }

    public final TerminationData checkIdle()
	throws RemoteException
    {
	return checkLocalIdle();
    }

    protected static final TerminationData checkLocalIdle()
    {
	rjvm.termination.acquire();
	try
	{
	    return new TerminationData(amIdle, messages);
	}
	finally
	{
	    rjvm.termination.release();
	}
    }

   public static VM createVM(String onHost, String fromHost)
   {
      try
      {
	  Debug.println("rjvm's createVM1 "+onHost+" "+fromHost);
         return rjx.createVM(onHost, fromHost);
      }
      catch (RemoteException re)
      {
         throw new rjCommunicationException(re);
      }
   }
   public static VM createVM(VM host, String fromHost)
   {
      try
      {
	  Debug.println("rjvm's createVM2 "+host+" "+fromHost);
         return rjx.createVM(host, fromHost);
      }
      catch (RemoteException re)
      {
         throw new rjCommunicationException(re);
      }
   }
   public static VM createVM(String onHost, String fromHost,
      String cls, Class [] paramTypes, Object [] paramValues)
   {
      try
      {
	  Debug.println("rjvm's createVM3 "+onHost+" "+fromHost);
         return rjx.createVM(onHost, fromHost, cls, paramTypes, paramValues);
      }
      catch (RemoteException re)
      {
         throw new rjCommunicationException(re);
      }
   }
   public static VM createVM(VM host, String fromHost,
      String cls, Class [] paramTypes, Object [] paramValues)
   {
      try
      {
	  System.out.println("rjvm's createVM4 "+host+" "+fromHost);
         return rjx.createVM(host, fromHost, cls, paramTypes, paramValues);
      }
      catch (RemoteException re)
      {
         throw new rjCommunicationException(re);
      }
   }
}
