sub u_rj(\@) {
  my $A = shift(@_);
  # for translating and running a simple RJ program:
  #   usage: rj name_of_main_class [arguments to RJ program]
  #
  # assumes RJ program is exactly *.java.
  #
  # note: first removes *.class to be safe

  # handle -explicit or -implicit
  # that appear before name_of_main_class
  # (note: doesn't handle -version anymore since test for number of args
  # below would fail.)
  # so now correctly handle, e.g.,
  #    rj -explicit main.java (previously wasn't giving error)
  #    rj -explicit (previously wasn't giving error)
  my @args = @EMPTY;
  my $shiftcnt = 0; # bad idea to shift @A within foreach ...(@A)
  foreach my $a (@$A) {
    if ($a =~ /^-explicit$/ || $a =~ /^-implicit$/) {
	push(@args, $a);
	$shiftcnt++;
    }
    elsif ($a =~ /^-/) {
      $! = 1;
      die "unknown command line option\n";
    }
    else { # quit arg processing on first non "-" argument
      last;
    }
  }
  for (my $k=1; $k <= $shiftcnt; $k++) {
      shift(@$A);
  }

  # sanity check
  if ( @$A < 1 ) {
    $! = 1;
    die "usage: $0 name_of_main_class \[arguments to RJ program\]\n";
  }

  # some error checking to avoid common mistake: rj *.java
  if (@$A[0] =~ /\.java$/) {
    $! = 1;
    die "error: name_of_main_class is a .java file\n";
  }

  ##print "rj.pl $CLASSPATH \n";

  my @theargs = (@args, @$A); 

  ##print "u_rj @theargs zz \n";

  my $exitstatus;
  my $unused = # avoid "Useless use of not in void context..."
  ##!system("echo 001") &&
  !($exitstatus = u_rjt(@EMPTY)) &&
  ## !system("echo 006") &&
  !($exitstatus = u_rjrun( @theargs ));
  return $exitstatus;
}

