import edu.ucdavis.rj.*;
import edu.ucdavis.rj.BaseArmCode.*;

public class main {

    static int PR = 6; // number of processes
    static int ITERATIONS = 3; // number of iterations

    public static OpInni barrier = OpInni.newOpInni();

    public static void main(String [] args) {

        // ****** for now
	if ( PR <= 1 ) {
	    System.out.println("need PR > 1; PR is " + PR);
	    RJ.exit(0);  // Where n is the exit value currently ignored
        }

	// create instances of jacobi
        /// remote jacobi jcap[] = new remote jacobi[PR];

	RemoteRefs jcap[]  = new RemoteRefs [PR];

        System.out.println("before try");

	System.out.println("after jcap");
	for( int i = 0; i < PR; i++ ) {
	    jcap[i] = Create.createInstance("jacobi", i+1, PR);
	}

	// start the computation
	System.out.println("before start computation");
	OpProxy barr = new OpProxy(barrier);
	try {
	    for( int i = 0; i < PR; i++ ) {
		OpProxy compute = jcap[i].get("compute");
		compute.send(new Invocation(ITERATIONS, barr));
	    }
	} catch (Exception e) {
	    System.err.println("compute.send");
	    e.printStackTrace();
	}

	for( int k = 1; k <= ITERATIONS; k++ ) {
	    System.out.println("main iteration "+k);
	    final OpProxy allProceed[] = new OpProxy [PR]; 
	    final Integer [] data = new Integer[PR];
	    // here's the barrier:
	    // first wait for all to arrive:
	    ArmCode farmcode = new ArmCode() {
		    public void codeBlock(Invocation inv) {
			Integer id = (Integer)(inv.getParam(0));
			Integer item = (Integer)(inv.getParam(1));
			data[id-1] = item;
			allProceed[id-1] = inv.getReplyOp();
			///////// some magic:
			//////// to prevent the reply now...
			inv.setReplyOp(null);
		    }
		};
	    InniArm farm = new InniArm(barrier, farmcode);
	    Inni inni1 = new Inni( farm );
	    for (int i = 0; i < PR; i++) {
		inni1.service();
	    }
	    // then respond to all by giving them all the data
	    for (int i = 0; i < PR; i++) {
		OpProxy replyOp = allProceed[i];
		Invocation rinv = new Invocation();
		rinv.setReturnValue(data);
		try {
		    replyOp.send(rinv);
		} catch (Exception e) {
		    System.err.println("replyOp.send");
		    e.printStackTrace();
		}
	    }
	}

	/////// quiescence is likely bogus, so ...
	/******
	RJ.nap(3000);
	RJ.exit(0);  // Where n is the exit value currently ignored
	*******/
    }

}
