// check whether noop really equals remote noop
// w.r.t. collections.

import edu.ucdavis.rj.*;

import java.util.*;

public class Eq {

    public static void main(String[] a){
	System.out.println("Starting...");

	OpProxy aa, bb;
	aa = new OpProxy(OpInni.noop);

	RemoteRefs funRefs;
	funRefs = Create.createInstance("fun", "-HACK-");

	doIt(aa, funRefs);

	VM v1;
	v1 = Create.createVM();

	RemoteRefs funRefs2;
	funRefs2 = Create.createInstance(v1, "fun", "-onpc11-");

	doIt(aa, funRefs2);

	System.out.println("Main complete.");
    }

    static void doIt(OpProxy aa, RemoteRefs funRefs) {

	OpProxy thefun;
	thefun = funRefs.get("g");

	OpInni ret = OpInni.newOpInni();

	try {
	    thefun.send(new Invocation(5681, new OpProxy(ret)));
	} catch (Exception e) {
	    System.err.println("thefun.send");
	    e.printStackTrace();
	}

	Invocation rinv;
	OpProxy bb;

	rinv = ret.receive();
	System.out.println("main got ret");
	bb = (OpProxy)(rinv.getParam(0));

	System.out.println("OpInni.noop.equals(aa)? "+OpInni.noop.equals(aa));
	System.out.println("aa.equals(OpInni.noop)? "+aa.equals(OpInni.noop));
	System.out.println("OpInni.noop.equals(bb)? "+OpInni.noop.equals(bb));
	System.out.println("bb.equals(OpInni.noop)? "+bb.equals(OpInni.noop));

	System.out.println("aa.equals(bb)? "+aa.equals(bb));
	System.out.println("bb.equals(aa)? "+bb.equals(aa));

	List<OpProxy> hs = new ArrayList<OpProxy>();
	hs.add(aa);
	System.out.println("hs.remove(bb)? "+hs.remove(bb));
	System.out.println("hs.remove(aa)? "+hs.remove(aa));

	List<OpProxy> hs2 = new ArrayList<OpProxy>();
	hs.add(bb);
	System.out.println("hs.remove(bb)? "+hs.remove(bb));
	System.out.println("hs.remove(aa)? "+hs.remove(aa));

    }
}
