import edu.ucdavis.rj.*;

import java.util.ArrayList;
import java.util.Iterator;

public class MyShape<E>
{
	private E id;
	///public cap cap E (E) (cap E(E)) mycap = new op cap E(E) (cap E(E));
	OpProxy mycap = new OpProxy(OpInni.newOpInni());

	public MyShape(E id)
	{
		this.id = id;
	}

        public OpMethod get, set, print;
        {
            try {
                get = new OpMethod() {
                        public void codeBlock(Invocation inv) {
			    inv.setReturnValue(id);
                        }
                    };
                set = new OpMethod() {
                        public void codeBlock(Invocation inv) {
			    E invId = (E)(inv.getParam(0));
			    id = invId;
                        }
                    };
                print = new OpMethod() {
                        public void codeBlock(Invocation inv) {
			    System.out.println("MyShape " + id);
                        }
                    };
            } catch (Exception e) {
                System.err.println("OpMethods");
                e.printStackTrace();
            }
        }

	public String toString() {
		return id.toString();
	}

	public static void main(String [] args)
	{
		ArrayList<MyShape> shapes = new ArrayList<MyShape>();

		MyShape<String> square = new MyShape<String>("square");
		MyShape<String> triangle = new MyShape<String>("triangle");
		MyShape<String> rectangle = new MyShape<String>("rectangle");

		shapes.add(square);
		shapes.add(triangle);
		shapes.add(rectangle);

		System.out.println("A list of shapes: ");
		for (Iterator<MyShape> it = shapes.iterator(); it.hasNext();)
		{
			it.next().print.call();
		}

                System.out.println("changing triangle to equilateral triangle...");
                triangle.set.call(new Invocation("equilateral triangle"));
		Invocation rinv = triangle.get.call();
                System.out.println("shape just changed: " + rinv.getReturnValue());


                System.out.println("Now the list of shapes becomes: ");
                for (Iterator<MyShape> it = shapes.iterator(); it.hasNext();)
		    {
                        it.next().print.call();
		    }


		try {
		    square.mycap.send(new Invocation("hihi"));
		} catch (Exception e) {
		    System.err.println("square.mycap.send");
		    e.printStackTrace();
		}

		ArmCode mcode = new ArmCode() {
			public void codeBlock(Invocation inv) {
			    String x = (String)(inv.getParam(0));
			    System.out.println("send serviced by inni: "+x);
			    inv.reply(x);
			}
		    };
		InniArm marm = new InniArm(square.mycap, mcode);

		Inni inni0 = new Inni( marm );
		inni0.service();


		try {
		    square.mycap.send(new Invocation("hi2hi"));
		} catch (Exception e) {
		    System.err.println("square.mycap.send");
		    e.printStackTrace();
		}

		try {
		    rinv = square.mycap.receive();
		} catch (Exception e) {
		    System.err.println("square.mycap.send");
		    e.printStackTrace();
		}
		String result = (String)(rinv.getParam(0));
		System.out.println("send serviced by receive: "+result);
	}
}
