/**
Purpose:
This file tests the following:
1. Timeout value is 0 or -1
2. send a op to inni arm that has elseafter
3. just the inni statement with elseafter

outcome:
1. If timeout value is 0 or negative, the timeafter arm will behave like a
regular else arm.

2. If we send an op, the inni arm should be execute.  

3. If there is no send statement, the elseafter arm should be executed 

**/

import edu.ucdavis.rj.*;

public class Main {

    public static void main(String [] args ) {

	OpInni joo = OpInni.newOpInni();

	int TIMEOUT;
	TIMEOUT = Integer.parseInt(args[0]);
   
	int SENDFLAG;  //1 -- do send joo, 0 -- do not send joo
	SENDFLAG = Integer.parseInt(args[1]);

	if( SENDFLAG == 1) {
	    joo.send();
	    joo.send();
	}

	System.out.println("hi");
	/***
	    inni void joo(){ 
	    System.out.println("in joo");
	    }
	    [] elseafter TIMEOUT { 
	    System.out.println("in elseafter"); 
	    }
	***/

	ArmCode jcode = new ArmCode() {
		public void codeBlock(Invocation inv) {
		    System.out.println("in joo");
		}
	    };
	InniArm jarm = new InniArm(joo, jcode);

	InniArmElseCode elsecode = new InniArmElseCode() {
		public void codeBlock() {
		    System.out.println("in elseafter"); 
		}
	    };

	InniArmElseafter elseafterArm = new InniArmElseafter(TIMEOUT, elsecode);
	Inni inni1 = new Inni( elseafterArm, jarm );
	inni1.service();
	
	System.out.println("bye");

	System.out.println("hi");
	inni1.service();
	System.out.println("bye");
    }
}
