import edu.ucdavis.rj.*;
import edu.ucdavis.rj.BaseArmCode.*;

public class main {

    public static OpInni terminate = OpInni.newOpInni();

    // default values, eventually read as args
    static int N = 8;
    static int PR = 2;
    static int S = N/PR;

    static double l, t, r, b, epsilon;

    public static void main(String [] args) {

        // eventually read as input
	l = 1; t = 2.1; r = 3.3; b = 4.9;
        epsilon = 0.3;

        // ****** for now
	if ( PR <= 1 ) {
	    System.out.println("need PR > 1; PR is " + PR);
	    RJ.exit(0);  // Where n is the exit value currently ignored
        }

	// create instances of jacobi
        /// remote jacobi jcap[] = new remote jacobi[PR];

	RemoteRefs jcap[]  = new RemoteRefs [PR];

        System.out.println("before try");

	// jcap[0] = new remote jacobi(1,N,PR,S,l,t,r,0.0);
	jcap[0] = Create.createInstance("jacobi", 1,N,PR,S,l,t,r,0.0);
	System.out.println("after jcap");
	for( int i = 1; i <= PR-2; i++ ) {
	    // jcap[i] = new remote jacobi(i+1,N,PR,S,l,0.0,r,0.0);
	    jcap[i] = Create.createInstance("jacobi", i+1,N,PR,S,l,0.0,r,0.0);
	}
	//jcap[PR-1] = new remote jacobi(PR,N,PR,S,l,0.0,r,b);
	jcap[PR-1] = Create.createInstance("jacobi", PR,N,PR,S,l,0.0,r,b);

	// start the computation
	System.out.println("before start computation");
	OpProxy term = new OpProxy(terminate);
	try {
	    //	send jcap[0].compute(jcap[0], jcap[1], terminate);
	    OpProxy compute = jcap[0].get("compute");
	    compute.send(new Invocation(jcap[0], jcap[1], term));
	    for( int i = 1; i <= PR-2; i++ ) {
		// send jcap[i].compute(jcap[i-1],jcap[i+1],terminate);
		compute = jcap[i].get("compute");
		compute.send(new Invocation(jcap[i-1],jcap[i+1],term));
	    }
	    //          send jcap[PR-1].compute(jcap[PR-2],noop, terminate);
	    // send jcap[PR-1].compute(jcap[PR-2],jcap[0], terminate);
	    compute = jcap[PR-1].get("compute");
	    compute.send(new Invocation(jcap[PR-2],jcap[0], term));
	} catch (Exception e) {
	    System.err.println("compute.send");
	    e.printStackTrace();
	}


	// do termination checks until convergence
	// 2000-03-06 no st or by on inni, so simulate it with recursion
	// ugh or elegant ;-)
        System.out.println("before convergence check");
	int iters = 0;
	while ( true ) {
	    iters++;
	    Invocation rinv = terminate_check.call();
	    boolean done = (Boolean)(rinv.getReturnValue());
	    if (done)
		break;
	}
	System.out.println("iters="+iters);
	
	/////// quiescence is likely bogus, so ...
	///JR.nap(3000);
	///JR.exit(0);  // Where n is the exit value currently ignored
    }


    private static int tlevel = 0;
    private static boolean tans = true;
    private static boolean tc_ans = false; // initialize to keep Java quiet

    private static OpImpl terminate_check;
    
    static {
	try {
	    terminate_check = new OpMethod() {
		    public void codeBlock(Invocation inv) {
			ArmCode farmcode = new ArmCode() {
				public void codeBlock(Invocation inv) {
				    double diff = (Double)(inv.getParam(0));
				    tans &= (diff <= epsilon);
				    tlevel++;
				    //        System.out.println("terminate tlevel="+tlevel+" diff="+diff);
				    if (tlevel == PR) { // have seen all PR diffs.
					tc_ans = tans;
					// initialize for next time
					tans = true;
					tlevel = 0;
					inv.setReturnValue(tc_ans);
				    }
				    else {
					Invocation rinv = terminate_check.call();
					tc_ans = (Boolean)(rinv.getReturnValue());
					inv.setReturnValue(tc_ans);
				    }
				}
			    };
			InniArm farm = new InniArm(terminate, farmcode);
			Inni inni1 = new Inni( farm );
			inni1.service();
			inv.setReturnValue(tc_ans);
		    }
		};
	} catch (Exception e) {
	    System.err.println("init opmethods");
	    e.printStackTrace();
	}
    }
}
