import edu.ucdavis.rj.*;

public class Servant {

    // operations invoked by philosophers
    public OpInni getforks = OpInni.newOpInni();
    public OpInni relforks = OpInni.newOpInni();

    int N;

    public Servant(int xN) {
        N = xN;
	try {
	    server.send(new Invocation());
	} catch (Exception e) {
	    System.err.println("server.send");
	    e.printStackTrace();
	}
    }

    // status of philosophers
    boolean [] eating;

    OpMethod server;

    {
	try {
	    server = new OpMethod() {
		    public void codeBlock(Invocation pinv) {
			System.out.println("starting up Servant");

			eating = new boolean[N];
			for (int i = 0; i < N ; i++ ) {
			    eating[i] = false;
			}

			// inni void getforks(int id) st oktoeat(id) {
			//   eating[id] = true;
			// }
			// [] void relforks(int id) {
			//   eating[id] = false;
			// }
			InniArm.SuchThat gst = new InniArm.SuchThat() {
				public boolean expr(Invocation inv) {
				    int id = (Integer)(inv.getParam(0));
				    return oktoeat(id);
				}
			    };
			ArmCode gcode = new ArmCode() {
				public void codeBlock(Invocation inv) {
				    int id = (Integer)(inv.getParam(0));
				    eating[id] = true;
				}
			    };

			InniArm garm = new InniArm(getforks, gst, gcode);

			ArmCode rcode = new ArmCode() {
				public void codeBlock(Invocation inv) {
				    int id = (Integer)(inv.getParam(0));
				    eating[id] = false;
				}
			    };

			InniArm rarm = new InniArm(relforks, rcode);

			Inni inni1 = new Inni( garm, rarm );

			while( true ) {
			    inni1.service();
			}
		    }
		};
	} catch (Exception e) {
	    System.err.println("server");
	    e.printStackTrace();
	}
    }


    // check whether either philosopher neighboring philosopher id is eating.
    // (add in N so that remainder (%) returns non-negative result.)
    private boolean oktoeat(int id) {
        return !eating[((id+N)+1)%N] && !eating[((id+N)-1)%N];
    }
}

