import edu.ucdavis.rj.*;

public class Servant {

    // operations invoked by associated philosopher
    public OpMethod getforks;
    public OpInni relforks = OpInni.newOpInni();

    // operations invoked by neighboring servants
    public OpInni needL = OpInni.newOpInni();
    public OpInni needR = OpInni.newOpInni();
    public OpInni passL = OpInni.newOpInni();
    public OpInni passR = OpInni.newOpInni();

    // initialization operations invoked by Main
    public OpInni links = OpInni.newOpInni();
    public OpInni forks = OpInni.newOpInni();

    // used internally
    private OpInni hungry = OpInni.newOpInni();
    private OpInni eat = OpInni.newOpInni();

    int id;

    public Servant(int id) {
        this.id = id;
	try {
	    server.send();
	} catch (Exception e) {
	    System.err.println("server.send");
	    e.printStackTrace();
	}
    }

    private boolean haveL, dirtyL, haveR, dirtyR;
    private RemoteRefs l, r;

    {
	try {
	    getforks = new OpMethod() {
		    public void codeBlock(Invocation inv) {
			try {
			    hungry.send();
			    eat.receive();
			} catch (Exception e) {
			    System.err.println("getforks");
			    e.printStackTrace();
			}
		    }
		};
	} catch (Exception e) {
	    System.err.println("getforks");
	    e.printStackTrace();
	}
    }


    // could put this inside of codeblock, but slightly neater this way?
    Inni inni2, inni3, inni4, inni5;

    OpMethod server;

    {
	try {
	    server = new OpMethod() {
		    public void codeBlock(Invocation inv) {
			System.out.println("starting up Servant "+id);

			Invocation rinv;

			rinv = links.receive();
			l = (RemoteRefs)(rinv.getParam(0));
			r = (RemoteRefs)(rinv.getParam(1));

			rinv = forks.receive();
			haveL = (Boolean)(rinv.getParam(0));
			dirtyL = (Boolean)(rinv.getParam(1));
			haveR = (Boolean)(rinv.getParam(2));
			dirtyR = (Boolean)(rinv.getParam(3));

			System.out.println("Servant got initial forks and links "+id);



			ArmCode passRcode2 = new ArmCode() {
				public void codeBlock(Invocation inv) {
				    haveR = true; dirtyR = false;
				}
			    };

			InniArm passRarm2 = new InniArm(passR, passRcode2);

			ArmCode passLcode2 = new ArmCode() {
				public void codeBlock(Invocation inv) {
				    haveL = true; dirtyL = false;
				}
			    };

			InniArm passLarm2 = new InniArm(passL, passLcode2);

			ArmCode nRcode2 = new ArmCode() {
				public void codeBlock(Invocation inv) {
				    haveR = false; dirtyR = false;
				    OpProxy pass = r.get("passL");
				    OpProxy need = r.get("needL");
				    try {
					pass.send();
					need.send();
				    } catch (Exception e) {
					System.err.println("need");
					e.printStackTrace();
				    }
				}
			    };

			InniArm nRarm2 = new InniArm(needR, nRcode2);

			ArmCode nLcode2 = new ArmCode() {
				public void codeBlock(Invocation inv) {
				    haveL = false; dirtyL = false;
				    OpProxy pass = l.get("passR");
				    OpProxy need = l.get("needR");
				    try {
					pass.send();
					need.send();
				    } catch (Exception e) {
					System.err.println("need");
					e.printStackTrace();
				    }
				}
			    };

			InniArm nLarm2 = new InniArm(needL, nLcode2);

			// this is sort of neat:
			// doing it w/o st allows arms to be reused.
			inni2 = new Inni( passRarm2, passLarm2, nRarm2, nLarm2 );
			inni3 = new Inni( passRarm2, passLarm2, nRarm2         );
			inni4 = new Inni( passRarm2, passLarm2,         nLarm2 );
			inni5 = new Inni( passRarm2, passLarm2                 );


			ArmCode hcode = new ArmCode() {
				public void codeBlock(Invocation inv) {
				    try {
					// ask for forks I don't have; I ask my
					// right neighbor for its left fork,
					// and my left neighbor for its right fork
					if (!haveR) {
					    OpProxy need = r.get("needL");
					    need.send();
					}
					if (!haveL) {
					    OpProxy need = l.get("needR");
					    need.send();
					}

					// wait until I have both forks
					while( !(haveL && haveR) ) {
					    if ( dirtyR && dirtyL ) {
						inni2.service();
					    }
					    else if ( dirtyR && !dirtyL ) {
						inni3.service();
					    }
					    else if ( !dirtyR && dirtyL ) {
						inni4.service();
					    }
					    else { // if ( !dirtyR && !dirtyL )
						inni5.service();
					    }
					}

					// give go-ahead
				        eat.send(); dirtyL = true; dirtyR = true;
				        relforks.receive(); // wait until Philosopher is done
				    } catch (Exception e) {
					System.err.println("hcode");
					e.printStackTrace();
				    }
				}
			    };

			InniArm harm = new InniArm(hungry, hcode);

			ArmCode nRcode = new ArmCode() {
				public void codeBlock(Invocation inv) {
				    // neighbor needs my right fork (its left)
				    haveR = false; dirtyR = false;
				    OpProxy pass = r.get("passL");
				    try {
					pass.send();
				    } catch (Exception e) {
					System.err.println("need");
					e.printStackTrace();
				    }
				}
			    };

			InniArm nRarm = new InniArm(needR, nRcode);

			ArmCode nLcode = new ArmCode() {
				public void codeBlock(Invocation inv) {
				    // neighbor needs my left fork (its right)
				    haveL = false; dirtyL = false;
				    OpProxy pass = l.get("passR");
				    try {
					pass.send();
				    } catch (Exception e) {
					System.err.println("need");
					e.printStackTrace();
				    }
				}
			    };

			InniArm nLarm = new InniArm(needL, nLcode);

			Inni inni1 = new Inni( harm, nRarm, nLarm );

			while( true ) {
			    inni1.service();
			}
		    }
		};
	} catch (Exception e) {
	    System.err.println("server");
	    e.printStackTrace();
	}
    }

}

