import edu.ucdavis.rj.*;

public class Server {

    // operations invoked by Readers/Writers
    public OpInni readRequest = OpInni.newOpInni();
    public OpInni readRelease = OpInni.newOpInni();
    public OpInni writeRequest = OpInni.newOpInni();
    public OpInni writeRelease = OpInni.newOpInni();

    public Server() {
	try {
	    server.send();
	} catch (Exception e) {
	    System.err.println("server.send");
	    e.printStackTrace();
	}
    }

    int nw = 0, nr = 0; // class-level so can access easily w/i armcode. ugh.

    OpMethod server;

    {
	try {
	    server = new OpMethod() {
		    public void codeBlock(Invocation pinv) {

			System.out.println("starting up server");

			// shows InniArm re-use:
			//   InniArm used in more than 1 Inni.
			// formation of Inni before code that uses it.

			ArmCode readRequestCode = new ArmCode() {
				public void codeBlock(Invocation inv) {
				    nr++;
				}
			    };

			ArmCode readReleaseCode = new ArmCode() {
				public void codeBlock(Invocation inv) {
				    nr--;
				}
			    };

			ArmCode writeRequestCode = new ArmCode() {
				public void codeBlock(Invocation inv) {
				    nw++;
				}
			    };

			ArmCode writeReleaseCode = new ArmCode() {
				public void codeBlock(Invocation inv) {
				    nw--;
				}
			    };

			InniArm readRequestArm = new InniArm(readRequest, readRequestCode);
			InniArm readReleaseArm = new InniArm(readRelease, readReleaseCode);
			InniArm writeRequestArm = new InniArm(writeRequest, writeRequestCode);
			InniArm writeReleaseArm = new InniArm(writeRelease, writeReleaseCode);
			Inni inni1 = new Inni( readRequestArm, writeRequestArm );
			Inni inni2 = new Inni( writeReleaseArm );
			Inni inni3 = new Inni( readRequestArm, readReleaseArm );

			while (true) { // on each iteration, service a R or W request or release
			    System.out.println("Server nw,nr="+nw+" "+nr);
			    if ((nw == 0) && (nr == 0)) {
				// inni void readRequest() { nr++; }
				// [] void writeRequest() { nw++; }
				inni1.service();
			    } else if (nw > 0) {
				// inni void writeRelease() { nw--; }
				inni2.service();
			    } else if (nr > 0) {
				// inni void readRequest() { nr++; }
				// [] void readRelease() { nr--; }
				inni3.service();
			    }
			}
		    }
		};
	} catch (Exception e) {
	    System.err.println("server");
	    e.printStackTrace();
	}
    }
}

