import edu.ucdavis.rj.*;

public class Server {

    // operations invoked by Readers/Writers
    public OpInni readRequest = OpInni.newOpInni();
    public OpInni readRelease = OpInni.newOpInni();
    public OpInni writeRequest = OpInni.newOpInni();
    public OpInni writeRelease = OpInni.newOpInni();

    public Server() {
	try {
	    server.send();
	} catch (Exception e) {
	    System.err.println("server.send");
	    e.printStackTrace();
	}
    }

    // class-level so can access easily w/i armcode. ugh.
    int nw = 0, nr = 0;
    Inni inni1, inni2, inni3, theInni;

    OpMethod server;

    {
	try {
	    server = new OpMethod() {
		    public void codeBlock(Invocation pinv) {

			System.out.println("starting up server");

			// shows InniArm re-use:
			//   InniArm used in more than 1 Inni.
			// formation of Inni before code that uses it.
			// "dynamic" inni: which inni we execute
			//  can change on each iteration of loop.

			// don't need variable nw anymore
			// and use nr in just one place.
			// (but kept for output)

			ArmCode readRequestCode = new ArmCode() {
				public void codeBlock(Invocation inv) {
				    nr++;
				    theInni = inni3;
				}
			    };

			ArmCode readReleaseCode = new ArmCode() {
				public void codeBlock(Invocation inv) {
				    nr--;
				    theInni = (nr > 0)?inni3:inni1;
				}
			    };

			ArmCode writeRequestCode = new ArmCode() {
				public void codeBlock(Invocation inv) {
				    nw++;
				    theInni = inni2;
				}
			    };

			ArmCode writeReleaseCode = new ArmCode() {
				public void codeBlock(Invocation inv) {
				    nw--;
				    theInni = inni1;
				}
			    };

			InniArm readRequestArm = new InniArm(readRequest, readRequestCode);
			InniArm readReleaseArm = new InniArm(readRelease, readReleaseCode);
			InniArm writeRequestArm = new InniArm(writeRequest, writeRequestCode);
			InniArm writeReleaseArm = new InniArm(writeRelease, writeReleaseCode);
			inni1 = new Inni( readRequestArm, writeRequestArm );
			inni2 = new Inni( writeReleaseArm );
			inni3 = new Inni( readRequestArm, readReleaseArm );

			theInni = inni1;

			while (true) { // on each iteration, service a R or W request or release
			    System.out.println("Server nw,nr="+nw+" "+nr);
			    theInni.service();
			}
		    }
		};
	} catch (Exception e) {
	    System.err.println("server");
	    e.printStackTrace();
	}
    }
}

