//  a simple semaphore test.
//
//  just give a list of small integers to test; they should be echoed in order.
//
//  example: a.out 2 7 8 1 8 2 8

import edu.ucdavis.rj.*;

public class semtest {

    private static final int N = 9;		// maximum input int

    // semaphore for signalling one more number done
    private static OpInni done = OpInni.newSem(0);

    private static OpImpl spin;

    // array of semaphores; go[i] is for signalling writer i to go
    private static OpInni go[] = new OpInni[N+1];

    public static void main(String [] args) {

	Debug.turnOff();

	// set up array of sems.
	for (int i = 0; i <= N; i++ ) {
	    go[i] = OpInni.newSem();
	}
    
	for (int i = 0; i <= N; i++ ) { // start up writers
	    spin.send(new Invocation(i));
	}

	for (int i = 0; i < args.length; i++) {
	    int n = Integer.parseInt(args[i]);	// get number
	    ////    System.out.println("loop i n "+i+" "+n);
	    go[n].V();			// tell that writer to go
	    done.P();			// wait for it to finish
	}
	System.out.println("");		// terminate output
    				        // and quit

        /////// quiescence is likely bogus, so ...
	RJ.nap(3000);
	RJ.exit(0);  // Where n is the exit value currently ignored
    }

    static {
        try {

	    // spin waiting for a signal, then write own index
	    spin = new OpMethod() {
		    public void codeBlock(Invocation inv) {
			int i = (Integer)(inv.getParam(0));
			///System.out.println("spin: "+i);
			while(true){
			    ///System.out.println("spin P: "+i);
			    go[i].P();	// wait for semaphore
			    System.out.print(i+" ");	// write out own number
			    done.V();		// signal done
			}
		    }
		};

	} catch (Exception e) {
	    System.err.println("p's ");
	    e.printStackTrace();
	}
    }



}
