/****
# process create/destroy
# This tests how long it takes to create a proc.  The proc is
# created by a send.  The main process then blocks until the
# proc finishes. 
****/

import edu.ucdavis.rj.*;

public class RPCFork {
  
   // to control shutdown
    private OpInni done = OpInni.newSem(0);

   private int limit;
   private int factor;
   private int base;
   private int trials;

   public RPCFork(int factor, int base, int trials) {

      this.factor = factor;
      this.base   = base;
      this.trials = trials;

      limit = factor * base;

      caller.call();

   }

   // would-be process
    OpMethod server = null;
    OpMethod caller = null;
    {
        try {
            server = new OpMethod() {
		    public void codeBlock(Invocation pinv) {
			done.V();
		    }
		};
            caller = new OpMethod() {
		    public void codeBlock(Invocation pinv) {
			long start, finish;

			for (int t = 1; t <= trials; t++ ) {
			    start = System.currentTimeMillis();
			    for (int i = 1; i<=limit ; i++) {
				server.send();
				done.P();
			    }
			    finish =System.currentTimeMillis();
			    System.out.println(limit + " times   " + (finish-start) + " ms");
			}
		    }
		};
	} catch (Exception e) {
	    System.err.println("server or caller");
	    e.printStackTrace();
	}
    }

}
