.file	"aesni-x86.s"
.text
.globl	aesni_encrypt
.type	aesni_encrypt,@function
.align	16
aesni_encrypt:
.L_aesni_encrypt_begin:
	movl	4(%esp),%eax
	movl	12(%esp),%edx
	movdqu	(%eax),%xmm0
	movl	240(%edx),%ecx
	movl	8(%esp),%eax
	movdqu	(%edx),%xmm3
	movaps	16(%edx),%xmm4
	leal	32(%edx),%edx
	pxor	%xmm3,%xmm0
.L000enc1_loop_1:
.byte	102,15,56,220,196
	decl	%ecx
	movaps	(%edx),%xmm4
	leal	16(%edx),%edx
	jnz	.L000enc1_loop_1
.byte	102,15,56,221,196
	movups	%xmm0,(%eax)
	ret
.size	aesni_encrypt,.-.L_aesni_encrypt_begin
.globl	aesni_decrypt
.type	aesni_decrypt,@function
.align	16
aesni_decrypt:
.L_aesni_decrypt_begin:
	movl	4(%esp),%eax
	movl	12(%esp),%edx
	movdqu	(%eax),%xmm0
	movl	240(%edx),%ecx
	movl	8(%esp),%eax
	movdqu	(%edx),%xmm3
	movaps	16(%edx),%xmm4
	leal	32(%edx),%edx
	pxor	%xmm3,%xmm0
.L001dec1_loop_2:
.byte	102,15,56,222,196
	decl	%ecx
	movaps	(%edx),%xmm4
	leal	16(%edx),%edx
	jnz	.L001dec1_loop_2
.byte	102,15,56,223,196
	movups	%xmm0,(%eax)
	ret
.size	aesni_decrypt,.-.L_aesni_decrypt_begin
.type	_aesni_encrypt3,@function
.align	16
_aesni_encrypt3:
	movaps	(%edx),%xmm3
	shrl	$1,%ecx
	movaps	16(%edx),%xmm4
	leal	32(%edx),%edx
	pxor	%xmm3,%xmm0
	pxor	%xmm3,%xmm1
	pxor	%xmm3,%xmm2
	movaps	(%edx),%xmm3
.L002enc3_loop:
.byte	102,15,56,220,196
.byte	102,15,56,220,204
	decl	%ecx
.byte	102,15,56,220,212
	movaps	16(%edx),%xmm4
.byte	102,15,56,220,195
.byte	102,15,56,220,203
	leal	32(%edx),%edx
.byte	102,15,56,220,211
	movaps	(%edx),%xmm3
	jnz	.L002enc3_loop
.byte	102,15,56,220,196
.byte	102,15,56,220,204
.byte	102,15,56,220,212
.byte	102,15,56,221,195
.byte	102,15,56,221,203
.byte	102,15,56,221,211
	ret
.size	_aesni_encrypt3,.-_aesni_encrypt3
.type	_aesni_decrypt3,@function
.align	16
_aesni_decrypt3:
	movaps	(%edx),%xmm3
	shrl	$1,%ecx
	movaps	16(%edx),%xmm4
	leal	32(%edx),%edx
	pxor	%xmm3,%xmm0
	pxor	%xmm3,%xmm1
	pxor	%xmm3,%xmm2
	movaps	(%edx),%xmm3
.L003dec3_loop:
.byte	102,15,56,222,196
.byte	102,15,56,222,204
	decl	%ecx
.byte	102,15,56,222,212
	movaps	16(%edx),%xmm4
.byte	102,15,56,222,195
.byte	102,15,56,222,203
	leal	32(%edx),%edx
.byte	102,15,56,222,211
	movaps	(%edx),%xmm3
	jnz	.L003dec3_loop
.byte	102,15,56,222,196
.byte	102,15,56,222,204
.byte	102,15,56,222,212
.byte	102,15,56,223,195
.byte	102,15,56,223,203
.byte	102,15,56,223,211
	ret
.size	_aesni_decrypt3,.-_aesni_decrypt3
.type	_aesni_encrypt4,@function
.align	16
_aesni_encrypt4:
	movaps	(%edx),%xmm3
	movaps	16(%edx),%xmm4
	shrl	$1,%ecx
	leal	32(%edx),%edx
	pxor	%xmm3,%xmm0
	pxor	%xmm3,%xmm1
	pxor	%xmm3,%xmm2
	pxor	%xmm3,%xmm7
	movaps	(%edx),%xmm3
.L004enc3_loop:
.byte	102,15,56,220,196
.byte	102,15,56,220,204
	decl	%ecx
.byte	102,15,56,220,212
.byte	102,15,56,220,252
	movaps	16(%edx),%xmm4
.byte	102,15,56,220,195
.byte	102,15,56,220,203
	leal	32(%edx),%edx
.byte	102,15,56,220,211
.byte	102,15,56,220,251
	movaps	(%edx),%xmm3
	jnz	.L004enc3_loop
.byte	102,15,56,220,196
.byte	102,15,56,220,204
.byte	102,15,56,220,212
.byte	102,15,56,220,252
.byte	102,15,56,221,195
.byte	102,15,56,221,203
.byte	102,15,56,221,211
.byte	102,15,56,221,251
	ret
.size	_aesni_encrypt4,.-_aesni_encrypt4
.type	_aesni_decrypt4,@function
.align	16
_aesni_decrypt4:
	movaps	(%edx),%xmm3
	movaps	16(%edx),%xmm4
	shrl	$1,%ecx
	leal	32(%edx),%edx
	pxor	%xmm3,%xmm0
	pxor	%xmm3,%xmm1
	pxor	%xmm3,%xmm2
	pxor	%xmm3,%xmm7
	movaps	(%edx),%xmm3
.L005dec3_loop:
.byte	102,15,56,222,196
.byte	102,15,56,222,204
	decl	%ecx
.byte	102,15,56,222,212
.byte	102,15,56,222,252
	movaps	16(%edx),%xmm4
.byte	102,15,56,222,195
.byte	102,15,56,222,203
	leal	32(%edx),%edx
.byte	102,15,56,222,211
.byte	102,15,56,222,251
	movaps	(%edx),%xmm3
	jnz	.L005dec3_loop
.byte	102,15,56,222,196
.byte	102,15,56,222,204
.byte	102,15,56,222,212
.byte	102,15,56,222,252
.byte	102,15,56,223,195
.byte	102,15,56,223,203
.byte	102,15,56,223,211
.byte	102,15,56,223,251
	ret
.size	_aesni_decrypt4,.-_aesni_decrypt4
.globl	aesni_ecb_encrypt
.type	aesni_ecb_encrypt,@function
.align	16
aesni_ecb_encrypt:
.L_aesni_ecb_encrypt_begin:
	pushl	%ebp
	pushl	%ebx
	pushl	%esi
	pushl	%edi
	movl	20(%esp),%esi
	movl	24(%esp),%edi
	movl	28(%esp),%eax
	movl	32(%esp),%edx
	movl	36(%esp),%ecx
	cmpl	$16,%eax
	jb	.L006ecb_ret
	andl	$-16,%eax
	testl	%ecx,%ecx
	movl	240(%edx),%ecx
	movl	%edx,%ebp
	movl	%ecx,%ebx
	jz	.L007ecb_decrypt
	cmpl	$64,%eax
	jbe	.L008ecb_enc_tail
	subl	$64,%eax
	jmp	.L009ecb_enc_loop3
.align	16
.L009ecb_enc_loop3:
	movups	(%esi),%xmm0
	movups	16(%esi),%xmm1
	movups	32(%esi),%xmm2
	call	_aesni_encrypt3
	leal	48(%esi),%esi
	movups	%xmm0,(%edi)
	movl	%ebp,%edx
	movups	%xmm1,16(%edi)
	movl	%ebx,%ecx
	movups	%xmm2,32(%edi)
	leal	48(%edi),%edi
	subl	$48,%eax
	ja	.L009ecb_enc_loop3
	addl	$64,%eax
.L008ecb_enc_tail:
	movups	(%esi),%xmm0
	cmpl	$32,%eax
	jb	.L010ecb_enc_one
	movups	16(%esi),%xmm1
	je	.L011ecb_enc_two
	movups	32(%esi),%xmm2
	cmpl	$48,%eax
	je	.L012ecb_enc_three
	movups	48(%esi),%xmm7
	call	_aesni_encrypt4
	movups	%xmm0,(%edi)
	movups	%xmm1,16(%edi)
	movups	%xmm2,32(%edi)
	movups	%xmm7,48(%edi)
	jmp	.L006ecb_ret
.align	16
.L010ecb_enc_one:
	movdqu	(%edx),%xmm3
	movaps	16(%edx),%xmm4
	leal	32(%edx),%edx
	pxor	%xmm3,%xmm0
.L013enc1_loop_3:
.byte	102,15,56,220,196
	decl	%ecx
	movaps	(%edx),%xmm4
	leal	16(%edx),%edx
	jnz	.L013enc1_loop_3
.byte	102,15,56,221,196
	movups	%xmm0,(%edi)
	jmp	.L006ecb_ret
.align	16
.L011ecb_enc_two:
	pxor	%xmm2,%xmm2
	call	_aesni_encrypt3
	movups	%xmm0,(%edi)
	movups	%xmm1,16(%edi)
	jmp	.L006ecb_ret
.align	16
.L012ecb_enc_three:
	call	_aesni_encrypt3
	movups	%xmm0,(%edi)
	movups	%xmm1,16(%edi)
	movups	%xmm2,32(%edi)
	jmp	.L006ecb_ret
.align	16
.L007ecb_decrypt:
	cmpl	$64,%eax
	jbe	.L014ecb_dec_tail
	subl	$64,%eax
	jmp	.L015ecb_dec_loop3
.align	16
.L015ecb_dec_loop3:
	movups	(%esi),%xmm0
	movups	16(%esi),%xmm1
	movups	32(%esi),%xmm2
	call	_aesni_decrypt3
	leal	48(%esi),%esi
	movups	%xmm0,(%edi)
	movl	%ebp,%edx
	movups	%xmm1,16(%edi)
	movl	%ebx,%ecx
	movups	%xmm2,32(%edi)
	leal	48(%edi),%edi
	subl	$48,%eax
	ja	.L015ecb_dec_loop3
	addl	$64,%eax
.L014ecb_dec_tail:
	movups	(%esi),%xmm0
	cmpl	$32,%eax
	jb	.L016ecb_dec_one
	movups	16(%esi),%xmm1
	je	.L017ecb_dec_two
	movups	32(%esi),%xmm2
	cmpl	$48,%eax
	je	.L018ecb_dec_three
	movups	48(%esi),%xmm7
	call	_aesni_decrypt4
	movups	%xmm0,(%edi)
	movups	%xmm1,16(%edi)
	movups	%xmm2,32(%edi)
	movups	%xmm7,48(%edi)
	jmp	.L006ecb_ret
.align	16
.L016ecb_dec_one:
	movdqu	(%edx),%xmm3
	movaps	16(%edx),%xmm4
	leal	32(%edx),%edx
	pxor	%xmm3,%xmm0
.L019dec1_loop_4:
.byte	102,15,56,222,196
	decl	%ecx
	movaps	(%edx),%xmm4
	leal	16(%edx),%edx
	jnz	.L019dec1_loop_4
.byte	102,15,56,223,196
	movups	%xmm0,(%edi)
	jmp	.L006ecb_ret
.align	16
.L017ecb_dec_two:
	pxor	%xmm2,%xmm2
	call	_aesni_decrypt3
	movups	%xmm0,(%edi)
	movups	%xmm1,16(%edi)
	jmp	.L006ecb_ret
.align	16
.L018ecb_dec_three:
	call	_aesni_decrypt3
	movups	%xmm0,(%edi)
	movups	%xmm1,16(%edi)
	movups	%xmm2,32(%edi)
.L006ecb_ret:
	popl	%edi
	popl	%esi
	popl	%ebx
	popl	%ebp
	ret
.size	aesni_ecb_encrypt,.-.L_aesni_ecb_encrypt_begin
.globl	aesni_ccm64_encrypt_blocks
.type	aesni_ccm64_encrypt_blocks,@function
.align	16
aesni_ccm64_encrypt_blocks:
.L_aesni_ccm64_encrypt_blocks_begin:
	pushl	%ebp
	pushl	%ebx
	pushl	%esi
	pushl	%edi
	movl	20(%esp),%esi
	movl	24(%esp),%edi
	movl	28(%esp),%eax
	movl	32(%esp),%edx
	movl	36(%esp),%ebx
	movl	40(%esp),%ecx
	movl	%esp,%ebp
	subl	$60,%esp
	andl	$-16,%esp
	movl	%ebp,48(%esp)
	movdqu	(%ebx),%xmm5
	movdqu	(%ecx),%xmm1
	movl	$202182159,(%esp)
	movl	$134810123,4(%esp)
	movl	$67438087,8(%esp)
	movl	$66051,12(%esp)
	movl	$1,%ecx
	xorl	%ebp,%ebp
	movl	%ecx,16(%esp)
	movl	%ebp,20(%esp)
	movl	%ebp,24(%esp)
	movl	%ebp,28(%esp)
	movdqa	(%esp),%xmm7
.byte	102,15,56,0,239
	movl	240(%edx),%ecx
	movl	%edx,%ebp
	movl	%ecx,%ebx
	movdqa	%xmm5,%xmm0
.L020ccm64_enc_outer:
	movdqu	(%esi),%xmm6
.byte	102,15,56,0,199
	movl	%ebp,%edx
	movl	%ebx,%ecx
	pxor	%xmm6,%xmm1
	pxor	%xmm2,%xmm2
	call	_aesni_encrypt3
	paddq	16(%esp),%xmm5
	decl	%eax
	leal	16(%esi),%esi
	pxor	%xmm0,%xmm6
	movdqa	%xmm5,%xmm0
	movdqu	%xmm6,(%edi)
	leal	16(%edi),%edi
	jnz	.L020ccm64_enc_outer
	movl	48(%esp),%esp
	movl	40(%esp),%edi
	movdqu	%xmm1,(%edi)
	popl	%edi
	popl	%esi
	popl	%ebx
	popl	%ebp
	ret
.size	aesni_ccm64_encrypt_blocks,.-.L_aesni_ccm64_encrypt_blocks_begin
.globl	aesni_ccm64_decrypt_blocks
.type	aesni_ccm64_decrypt_blocks,@function
.align	16
aesni_ccm64_decrypt_blocks:
.L_aesni_ccm64_decrypt_blocks_begin:
	pushl	%ebp
	pushl	%ebx
	pushl	%esi
	pushl	%edi
	movl	20(%esp),%esi
	movl	24(%esp),%edi
	movl	28(%esp),%eax
	movl	32(%esp),%edx
	movl	36(%esp),%ebx
	movl	40(%esp),%ecx
	movl	%esp,%ebp
	subl	$60,%esp
	andl	$-16,%esp
	movl	%ebp,48(%esp)
	movdqu	(%ebx),%xmm5
	movdqu	(%ecx),%xmm1
	movl	$202182159,(%esp)
	movl	$134810123,4(%esp)
	movl	$67438087,8(%esp)
	movl	$66051,12(%esp)
	movl	$1,%ecx
	xorl	%ebp,%ebp
	movl	%ecx,16(%esp)
	movl	%ebp,20(%esp)
	movl	%ebp,24(%esp)
	movl	%ebp,28(%esp)
	movdqa	(%esp),%xmm7
	movdqa	%xmm5,%xmm0
.byte	102,15,56,0,239
	movl	240(%edx),%ecx
	movl	%edx,%ebp
	movl	%ecx,%ebx
	movdqu	(%edx),%xmm3
	movaps	16(%edx),%xmm4
	leal	32(%edx),%edx
	pxor	%xmm3,%xmm0
.L021enc1_loop_5:
.byte	102,15,56,220,196
	decl	%ecx
	movaps	(%edx),%xmm4
	leal	16(%edx),%edx
	jnz	.L021enc1_loop_5
.byte	102,15,56,221,196
.L022ccm64_dec_outer:
	movdqu	(%esi),%xmm6
	paddq	16(%esp),%xmm5
	decl	%eax
	leal	16(%esi),%esi
	pxor	%xmm0,%xmm6
	movdqa	%xmm5,%xmm0
	movl	%ebp,%edx
	movl	%ebx,%ecx
.byte	102,15,56,0,199
	movdqu	%xmm6,(%edi)
	leal	16(%edi),%edi
	jz	.L023ccm64_dec_break
	pxor	%xmm2,%xmm2
	call	_aesni_encrypt3
	jmp	.L022ccm64_dec_outer
.align	16
.L023ccm64_dec_break:
	movdqu	(%edx),%xmm3
	movaps	16(%edx),%xmm4
	leal	32(%edx),%edx
	pxor	%xmm3,%xmm1
.L024enc1_loop_6:
.byte	102,15,56,220,204
	decl	%ecx
	movaps	(%edx),%xmm4
	leal	16(%edx),%edx
	jnz	.L024enc1_loop_6
.byte	102,15,56,221,204
	movl	48(%esp),%esp
	movl	40(%esp),%edi
	movdqu	%xmm1,(%edi)
	popl	%edi
	popl	%esi
	popl	%ebx
	popl	%ebp
	ret
.size	aesni_ccm64_decrypt_blocks,.-.L_aesni_ccm64_decrypt_blocks_begin
.globl	aesni_ctr32_encrypt_blocks
.type	aesni_ctr32_encrypt_blocks,@function
.align	16
aesni_ctr32_encrypt_blocks:
.L_aesni_ctr32_encrypt_blocks_begin:
	pushl	%ebp
	pushl	%ebx
	pushl	%esi
	pushl	%edi
	movl	20(%esp),%esi
	movl	24(%esp),%edi
	movl	28(%esp),%eax
	movl	32(%esp),%edx
	movl	36(%esp),%ebx
	movl	%esp,%ebp
	subl	$60,%esp
	andl	$-16,%esp
	movl	%ebp,48(%esp)
	cmpl	$1,%eax
	je	.L025ctr32_one_shortcut
	movups	(%ebx),%xmm7
	movl	$202182159,(%esp)
	movl	$134810123,4(%esp)
	movl	$67438087,8(%esp)
	movl	$66051,12(%esp)
	movl	$3,%ecx
	xorl	%ebp,%ebp
	movl	%ecx,16(%esp)
	movl	%ecx,20(%esp)
	movl	%ecx,24(%esp)
	movl	%ebp,28(%esp)
.byte	102,15,58,22,251,3
.byte	102,15,58,34,253,3
	movl	240(%edx),%ecx
	movdqa	(%esp),%xmm3
	pxor	%xmm5,%xmm5
	bswap	%ebx
.byte	102,15,58,34,235,0
	incl	%ebx
.byte	102,15,58,34,235,1
	incl	%ebx
.byte	102,15,58,34,235,2
.byte	102,15,56,0,235
	cmpl	$4,%eax
	jbe	.L026ctr32_tail
	movdqa	%xmm7,32(%esp)
	movl	%ecx,%ebx
	movl	%edx,%ebp
	subl	$4,%eax
	jmp	.L027ctr32_loop3
.align	16
.L027ctr32_loop3:
	pshufd	$192,%xmm5,%xmm0
	pshufd	$128,%xmm5,%xmm1
	por	%xmm7,%xmm0
	pshufd	$64,%xmm5,%xmm2
	por	%xmm7,%xmm1
	por	%xmm7,%xmm2
	movaps	(%edx),%xmm3
	shrl	$1,%ecx
	movaps	16(%edx),%xmm4
	leal	32(%edx),%edx
	pxor	%xmm3,%xmm0
	pxor	%xmm3,%xmm1
	pxor	%xmm3,%xmm2
	movaps	(%edx),%xmm3
.L028ctr32_enc_loop3:
.byte	102,15,56,220,196
.byte	102,15,56,220,204
	decl	%ecx
.byte	102,15,56,220,212
	movaps	16(%edx),%xmm4
.byte	102,15,56,220,195
.byte	102,15,56,220,203
	leal	32(%edx),%edx
.byte	102,15,56,220,211
	movaps	(%edx),%xmm3
	jnz	.L028ctr32_enc_loop3
.byte	102,15,56,220,196
.byte	102,15,56,220,204
.byte	102,15,56,220,212
	movdqa	(%esp),%xmm4
.byte	102,15,56,221,195
.byte	102,15,56,0,236
	movdqu	(%esi),%xmm6
.byte	102,15,56,221,203
	paddd	16(%esp),%xmm5
	movdqu	16(%esi),%xmm7
.byte	102,15,56,221,211
.byte	102,15,56,0,236
	movdqu	32(%esi),%xmm3
	leal	48(%esi),%esi
	pxor	%xmm0,%xmm6
	movl	%ebp,%edx
	pxor	%xmm1,%xmm7
	movdqu	%xmm6,(%edi)
	pxor	%xmm2,%xmm3
	movdqu	%xmm7,16(%edi)
	movdqu	%xmm3,32(%edi)
	movdqa	32(%esp),%xmm7
	subl	$3,%eax
	leal	48(%edi),%edi
	movl	%ebx,%ecx
	ja	.L027ctr32_loop3
.byte	102,15,58,22,235,1
	addl	$4,%eax
	bswap	%ebx
.L026ctr32_tail:
	pshufd	$192,%xmm5,%xmm0
	pshufd	$128,%xmm5,%xmm1
	por	%xmm7,%xmm0
	cmpl	$2,%eax
	jb	.L029ctr32_one
	leal	1(%ebx),%ebx
	pshufd	$64,%xmm5,%xmm2
	por	%xmm7,%xmm1
	je	.L030ctr32_two
	bswap	%ebx
	por	%xmm7,%xmm2
	cmpl	$3,%eax
	je	.L031ctr32_three
.byte	102,15,58,34,251,3
	call	_aesni_encrypt4
	movdqu	(%esi),%xmm6
	movdqu	16(%esi),%xmm4
	pxor	%xmm0,%xmm6
	movdqu	32(%esi),%xmm3
	pxor	%xmm1,%xmm4
	movdqu	48(%esi),%xmm5
	pxor	%xmm2,%xmm3
	movdqu	%xmm6,(%edi)
	pxor	%xmm7,%xmm5
	movdqu	%xmm4,16(%edi)
	movdqu	%xmm3,32(%edi)
	movdqu	%xmm5,48(%edi)
	jmp	.L032ctr32_ret
.align	16
.L025ctr32_one_shortcut:
	movdqu	(%ebx),%xmm0
	movl	240(%edx),%ecx
.L029ctr32_one:
	movdqu	(%edx),%xmm3
	movaps	16(%edx),%xmm4
	leal	32(%edx),%edx
	pxor	%xmm3,%xmm0
.L033enc1_loop_7:
.byte	102,15,56,220,196
	decl	%ecx
	movaps	(%edx),%xmm4
	leal	16(%edx),%edx
	jnz	.L033enc1_loop_7
.byte	102,15,56,221,196
	movdqu	(%esi),%xmm6
	pxor	%xmm0,%xmm6
	movdqu	%xmm6,(%edi)
	jmp	.L032ctr32_ret
.align	16
.L030ctr32_two:
	pxor	%xmm2,%xmm2
	call	_aesni_encrypt3
	movdqu	(%esi),%xmm6
	movdqu	16(%esi),%xmm7
	pxor	%xmm0,%xmm6
	pxor	%xmm1,%xmm7
	movdqu	%xmm6,(%edi)
	movdqu	%xmm7,16(%edi)
	jmp	.L032ctr32_ret
.align	16
.L031ctr32_three:
	call	_aesni_encrypt3
	movdqu	(%esi),%xmm6
	movdqu	16(%esi),%xmm7
	movdqu	32(%esi),%xmm4
	pxor	%xmm0,%xmm6
	pxor	%xmm1,%xmm7
	movdqu	%xmm6,(%edi)
	pxor	%xmm2,%xmm4
	movdqu	%xmm7,16(%edi)
	movdqu	%xmm4,32(%edi)
.L032ctr32_ret:
	movl	48(%esp),%esp
	popl	%edi
	popl	%esi
	popl	%ebx
	popl	%ebp
	ret
.size	aesni_ctr32_encrypt_blocks,.-.L_aesni_ctr32_encrypt_blocks_begin
.globl	aesni_cbc_encrypt
.type	aesni_cbc_encrypt,@function
.align	16
aesni_cbc_encrypt:
.L_aesni_cbc_encrypt_begin:
	pushl	%ebp
	pushl	%ebx
	pushl	%esi
	pushl	%edi
	movl	20(%esp),%esi
	movl	24(%esp),%edi
	movl	28(%esp),%eax
	movl	32(%esp),%edx
	movl	36(%esp),%ebp
	testl	%eax,%eax
	jz	.L034cbc_ret
	cmpl	$0,40(%esp)
	movdqu	(%ebp),%xmm5
	movl	240(%edx),%ecx
	movl	%edx,%ebp
	movl	%ecx,%ebx
	je	.L035cbc_decrypt
	movdqa	%xmm5,%xmm0
	cmpl	$16,%eax
	jb	.L036cbc_enc_tail
	subl	$16,%eax
	jmp	.L037cbc_enc_loop
.align	16
.L037cbc_enc_loop:
	movdqu	(%esi),%xmm5
	leal	16(%esi),%esi
	pxor	%xmm5,%xmm0
	movdqu	(%edx),%xmm3
	movaps	16(%edx),%xmm4
	leal	32(%edx),%edx
	pxor	%xmm3,%xmm0
.L038enc1_loop_8:
.byte	102,15,56,220,196
	decl	%ecx
	movaps	(%edx),%xmm4
	leal	16(%edx),%edx
	jnz	.L038enc1_loop_8
.byte	102,15,56,221,196
	movl	%ebx,%ecx
	movl	%ebp,%edx
	movups	%xmm0,(%edi)
	leal	16(%edi),%edi
	subl	$16,%eax
	jnc	.L037cbc_enc_loop
	addl	$16,%eax
	jnz	.L036cbc_enc_tail
	movaps	%xmm0,%xmm5
	jmp	.L034cbc_ret
.L036cbc_enc_tail:
	movl	%eax,%ecx
.long	2767451785
	movl	$16,%ecx
	subl	%eax,%ecx
	xorl	%eax,%eax
.long	2868115081
	leal	-16(%edi),%edi
	movl	%ebx,%ecx
	movl	%edi,%esi
	movl	%ebp,%edx
	jmp	.L037cbc_enc_loop
.align	16
.L035cbc_decrypt:
	cmpl	$64,%eax
	jbe	.L039cbc_dec_tail
	subl	$64,%eax
	jmp	.L040cbc_dec_loop3
.align	16
.L040cbc_dec_loop3:
	movups	(%esi),%xmm0
	movups	16(%esi),%xmm1
	movups	32(%esi),%xmm2
	movaps	%xmm0,%xmm6
	movaps	%xmm1,%xmm7
	call	_aesni_decrypt3
	pxor	%xmm5,%xmm0
	pxor	%xmm6,%xmm1
	movdqu	32(%esi),%xmm5
	leal	48(%esi),%esi
	pxor	%xmm7,%xmm2
	movdqu	%xmm0,(%edi)
	movl	%ebx,%ecx
	movdqu	%xmm1,16(%edi)
	movl	%ebp,%edx
	movdqu	%xmm2,32(%edi)
	leal	48(%edi),%edi
	subl	$48,%eax
	ja	.L040cbc_dec_loop3
	addl	$64,%eax
.L039cbc_dec_tail:
	movups	(%esi),%xmm0
	movaps	%xmm0,%xmm6
	cmpl	$16,%eax
	jbe	.L041cbc_dec_one
	movups	16(%esi),%xmm1
	movaps	%xmm1,%xmm7
	cmpl	$32,%eax
	jbe	.L042cbc_dec_two
	movups	32(%esi),%xmm2
	cmpl	$48,%eax
	jbe	.L043cbc_dec_three
	movups	48(%esi),%xmm7
	call	_aesni_decrypt4
	movdqu	16(%esi),%xmm3
	movdqu	32(%esi),%xmm4
	pxor	%xmm5,%xmm0
	pxor	%xmm6,%xmm1
	movdqu	48(%esi),%xmm5
	movdqu	%xmm0,(%edi)
	pxor	%xmm3,%xmm2
	pxor	%xmm4,%xmm7
	movdqu	%xmm1,16(%edi)
	movdqu	%xmm2,32(%edi)
	movdqa	%xmm7,%xmm0
	leal	48(%edi),%edi
	jmp	.L044cbc_dec_tail_collected
.align	16
.L041cbc_dec_one:
	movdqu	(%edx),%xmm3
	movaps	16(%edx),%xmm4
	leal	32(%edx),%edx
	pxor	%xmm3,%xmm0
.L045dec1_loop_9:
.byte	102,15,56,222,196
	decl	%ecx
	movaps	(%edx),%xmm4
	leal	16(%edx),%edx
	jnz	.L045dec1_loop_9
.byte	102,15,56,223,196
	pxor	%xmm5,%xmm0
	movdqa	%xmm6,%xmm5
	jmp	.L044cbc_dec_tail_collected
.align	16
.L042cbc_dec_two:
	pxor	%xmm2,%xmm2
	call	_aesni_decrypt3
	pxor	%xmm5,%xmm0
	pxor	%xmm6,%xmm1
	movdqu	%xmm0,(%edi)
	movdqa	%xmm1,%xmm0
	movdqa	%xmm7,%xmm5
	leal	16(%edi),%edi
	jmp	.L044cbc_dec_tail_collected
.align	16
.L043cbc_dec_three:
	call	_aesni_decrypt3
	pxor	%xmm5,%xmm0
	pxor	%xmm6,%xmm1
	pxor	%xmm7,%xmm2
	movdqu	%xmm0,(%edi)
	movdqu	%xmm1,16(%edi)
	movdqa	%xmm2,%xmm0
	movdqu	32(%esi),%xmm5
	leal	32(%edi),%edi
.L044cbc_dec_tail_collected:
	andl	$15,%eax
	jnz	.L046cbc_dec_tail_partial
	movdqu	%xmm0,(%edi)
	jmp	.L034cbc_ret
.align	16
.L046cbc_dec_tail_partial:
	movl	%esp,%ebp
	subl	$16,%esp
	andl	$-16,%esp
	movdqa	%xmm0,(%esp)
	movl	%esp,%esi
	movl	%eax,%ecx
.long	2767451785
	movl	%ebp,%esp
.L034cbc_ret:
	movl	36(%esp),%ebp
	movups	%xmm5,(%ebp)
	popl	%edi
	popl	%esi
	popl	%ebx
	popl	%ebp
	ret
.size	aesni_cbc_encrypt,.-.L_aesni_cbc_encrypt_begin
.type	_aesni_set_encrypt_key,@function
.align	16
_aesni_set_encrypt_key:
	testl	%eax,%eax
	jz	.L047bad_pointer
	testl	%edx,%edx
	jz	.L047bad_pointer
	movups	(%eax),%xmm0
	pxor	%xmm4,%xmm4
	leal	16(%edx),%edx
	cmpl	$256,%ecx
	je	.L04814rounds
	cmpl	$192,%ecx
	je	.L04912rounds
	cmpl	$128,%ecx
	jne	.L050bad_keybits
.align	16
.L05110rounds:
	movl	$9,%ecx
	movaps	%xmm0,-16(%edx)
.byte	102,15,58,223,200,1
	call	.L052key_128_cold
.byte	102,15,58,223,200,2
	call	.L053key_128
.byte	102,15,58,223,200,4
	call	.L053key_128
.byte	102,15,58,223,200,8
	call	.L053key_128
.byte	102,15,58,223,200,16
	call	.L053key_128
.byte	102,15,58,223,200,32
	call	.L053key_128
.byte	102,15,58,223,200,64
	call	.L053key_128
.byte	102,15,58,223,200,128
	call	.L053key_128
.byte	102,15,58,223,200,27
	call	.L053key_128
.byte	102,15,58,223,200,54
	call	.L053key_128
	movaps	%xmm0,(%edx)
	movl	%ecx,80(%edx)
	xorl	%eax,%eax
	ret
.align	16
.L053key_128:
	movaps	%xmm0,(%edx)
	leal	16(%edx),%edx
.L052key_128_cold:
	shufps	$16,%xmm0,%xmm4
	pxor	%xmm4,%xmm0
	shufps	$140,%xmm0,%xmm4
	pxor	%xmm4,%xmm0
	pshufd	$255,%xmm1,%xmm1
	pxor	%xmm1,%xmm0
	ret
.align	16
.L04912rounds:
	movq	16(%eax),%xmm2
	movl	$11,%ecx
	movaps	%xmm0,-16(%edx)
.byte	102,15,58,223,202,1
	call	.L054key_192a_cold
.byte	102,15,58,223,202,2
	call	.L055key_192b
.byte	102,15,58,223,202,4
	call	.L056key_192a
.byte	102,15,58,223,202,8
	call	.L055key_192b
.byte	102,15,58,223,202,16
	call	.L056key_192a
.byte	102,15,58,223,202,32
	call	.L055key_192b
.byte	102,15,58,223,202,64
	call	.L056key_192a
.byte	102,15,58,223,202,128
	call	.L055key_192b
	movaps	%xmm0,(%edx)
	movl	%ecx,48(%edx)
	xorl	%eax,%eax
	ret
.align	16
.L056key_192a:
	movaps	%xmm0,(%edx)
	leal	16(%edx),%edx
.align	16
.L054key_192a_cold:
	movaps	%xmm2,%xmm5
.L057key_192b_warm:
	shufps	$16,%xmm0,%xmm4
	movaps	%xmm2,%xmm3
	pxor	%xmm4,%xmm0
	shufps	$140,%xmm0,%xmm4
	pslldq	$4,%xmm3
	pxor	%xmm4,%xmm0
	pshufd	$85,%xmm1,%xmm1
	pxor	%xmm3,%xmm2
	pxor	%xmm1,%xmm0
	pshufd	$255,%xmm0,%xmm3
	pxor	%xmm3,%xmm2
	ret
.align	16
.L055key_192b:
	movaps	%xmm0,%xmm3
	shufps	$68,%xmm0,%xmm5
	movaps	%xmm5,(%edx)
	shufps	$78,%xmm2,%xmm3
	movaps	%xmm3,16(%edx)
	leal	32(%edx),%edx
	jmp	.L057key_192b_warm
.align	16
.L04814rounds:
	movups	16(%eax),%xmm2
	movl	$13,%ecx
	leal	16(%edx),%edx
	movaps	%xmm0,-32(%edx)
	movaps	%xmm2,-16(%edx)
.byte	102,15,58,223,202,1
	call	.L058key_256a_cold
.byte	102,15,58,223,200,1
	call	.L059key_256b
.byte	102,15,58,223,202,2
	call	.L060key_256a
.byte	102,15,58,223,200,2
	call	.L059key_256b
.byte	102,15,58,223,202,4
	call	.L060key_256a
.byte	102,15,58,223,200,4
	call	.L059key_256b
.byte	102,15,58,223,202,8
	call	.L060key_256a
.byte	102,15,58,223,200,8
	call	.L059key_256b
.byte	102,15,58,223,202,16
	call	.L060key_256a
.byte	102,15,58,223,200,16
	call	.L059key_256b
.byte	102,15,58,223,202,32
	call	.L060key_256a
.byte	102,15,58,223,200,32
	call	.L059key_256b
.byte	102,15,58,223,202,64
	call	.L060key_256a
	movaps	%xmm0,(%edx)
	movl	%ecx,16(%edx)
	xorl	%eax,%eax
	ret
.align	16
.L060key_256a:
	movaps	%xmm2,(%edx)
	leal	16(%edx),%edx
.L058key_256a_cold:
	shufps	$16,%xmm0,%xmm4
	pxor	%xmm4,%xmm0
	shufps	$140,%xmm0,%xmm4
	pxor	%xmm4,%xmm0
	pshufd	$255,%xmm1,%xmm1
	pxor	%xmm1,%xmm0
	ret
.align	16
.L059key_256b:
	movaps	%xmm0,(%edx)
	leal	16(%edx),%edx
	shufps	$16,%xmm2,%xmm4
	pxor	%xmm4,%xmm2
	shufps	$140,%xmm2,%xmm4
	pxor	%xmm4,%xmm2
	pshufd	$170,%xmm1,%xmm1
	pxor	%xmm1,%xmm2
	ret
.align	4
.L047bad_pointer:
	movl	$-1,%eax
	ret
.align	4
.L050bad_keybits:
	movl	$-2,%eax
	ret
.size	_aesni_set_encrypt_key,.-_aesni_set_encrypt_key
.globl	aesni_set_encrypt_key
.type	aesni_set_encrypt_key,@function
.align	16
aesni_set_encrypt_key:
.L_aesni_set_encrypt_key_begin:
	movl	4(%esp),%eax
	movl	8(%esp),%ecx
	movl	12(%esp),%edx
	call	_aesni_set_encrypt_key
	ret
.size	aesni_set_encrypt_key,.-.L_aesni_set_encrypt_key_begin
.globl	aesni_set_decrypt_key
.type	aesni_set_decrypt_key,@function
.align	16
aesni_set_decrypt_key:
.L_aesni_set_decrypt_key_begin:
	movl	4(%esp),%eax
	movl	8(%esp),%ecx
	movl	12(%esp),%edx
	call	_aesni_set_encrypt_key
	movl	12(%esp),%edx
	shll	$4,%ecx
	testl	%eax,%eax
	jnz	.L061dec_key_ret
	leal	16(%edx,%ecx,1),%eax
	movaps	(%edx),%xmm0
	movaps	(%eax),%xmm1
	movaps	%xmm0,(%eax)
	movaps	%xmm1,(%edx)
	leal	16(%edx),%edx
	leal	-16(%eax),%eax
.L062dec_key_inverse:
	movaps	(%edx),%xmm0
	movaps	(%eax),%xmm1
.byte	102,15,56,219,192
.byte	102,15,56,219,201
	leal	16(%edx),%edx
	leal	-16(%eax),%eax
	movaps	%xmm0,16(%eax)
	movaps	%xmm1,-16(%edx)
	cmpl	%edx,%eax
	ja	.L062dec_key_inverse
	movaps	(%edx),%xmm0
.byte	102,15,56,219,192
	movaps	%xmm0,(%edx)
	xorl	%eax,%eax
.L061dec_key_ret:
	ret
.size	aesni_set_decrypt_key,.-.L_aesni_set_decrypt_key_begin
.byte	65,69,83,32,102,111,114,32,73,110,116,101,108,32,65,69
.byte	83,45,78,73,44,32,67,82,89,80,84,79,71,65,77,83
.byte	32,98,121,32,60,97,112,112,114,111,64,111,112,101,110,115
.byte	115,108,46,111,114,103,62,0
