/*
 * Maximum number of handler threads.  Can be overridden in config file
 * with the NumHands option.
 */
#define COW_NOHAND 16

/*
 * We use pmsg's from a pre-allocated pool to avoid malloc/free overhead.
 * We want to actually allocate a multiple of the number of handler threads
 * we have in order to let the depot queue up some requests.  This constant
 * sets that multiple.  The total size of the pmsg pool will be
 * cow_nohand*POOL_SIZE_FACT.
 */
#define POOL_SIZE_FACT 4


//#define SOCKETBUF_SIZE                          8192
//#define SOCKETBUF_SIZE                          1024*16 // ok.
//#define SOCKETBUF_SIZE                          1024*64 // ok.
  #define SOCKETBUF_SIZE                          1024*4 // ok.
//#define SOCKETBUF_SIZE                          1024*256 // with *1024
//#define SOCKETBUF_SIZE                          1024*512   // with *1024
//#define SOCKETBUF_SIZE                          1024*1024   // with *2048

#define MAX_HEADER_LEN                          1024
#define MAX_SITENAME_LENGTH                     256

// hand.c only ; for limitting the length of request line.
#define MAXREQLINE 1024

#if defined HAVE_DIRENT_H
#include <dirent.h>             /* for MAXNAMLEN */
#elif defined HAVE_NDIR_H
#include <ndir.h>
#elif defined HAVE_SYS_DIR_H
#include <sys/dir.h>
#elif defined HAVE_SYS_NDIR_H
#include <sys/ndir.h>
#endif

# ifndef MAXNAMLEN
/* Get the definitions of the POSIX.1 limits.  */
#include <limits.h>
/* `MAXNAMLEN' is the BSD name for what POSIX calls `NAME_MAX'.  */
#  ifdef NAME_MAX
#   define MAXNAMLEN    NAME_MAX
#  else
#   define MAXNAMLEN    255
#  endif
# endif

#include <sys/types.h>
#include <sys/socket.h>
#ifndef SO_MAXCONN
#define SO_MAXCONN  128 //default in linux, 64 for bsd
#endif
// ok, here's another test:
//#define SO_MAXCONN COW_NOHAND/2
//#define SOMAXCONN COW_NOHAND/2

#define MAX_PATH_LENGTH                         NAME_MAX
#define MAX_REQ_URI_LEN                         256
#define MAX_URI_LEN                             MAX_PATH_LENGTH
#define MAX_BUF_SIZE                            SOCKETBUF_SIZE
#define MIME_TYPE_LEN                           32

/*********** KEEPALIVE CONSTANTS (req->keepalive) *******/
#define KA_INACTIVE     0
#define KA_STOPPED      1
#define KA_ACTIVE       2

#define KA_MAX_CON     16       /* max number of ka connection */
#define KA_MAX_DUR     10       /* max seconds of ka duration */

/* default values for port operations */
#define COW_RTO_S       3       /* recv or read from port TimeOut value (sec)*/
#define COW_RTO_U   10000       /* recv or read from port TimeOut value (usec)*/
/* currently not used (do we need these?) */
#define COW_WTO_S       0       /* same for write or send (but probably */
#define COW_WTO_U    1000       /* not needed cuz write error -> immediate -1 */

/* ugly macros */
# undef DB_FDX
# ifdef DB_FDX
#define DEB_FDX(X) \
{ \
  static int debug_op[1024]; \
  static int i,j=0,k; \
  for(i=0; i<1024; i++) { \
    debug_op[i]=open("/dev/null", O_RDONLY); \
    if(debug_op[i]>0) j++; \
  } \
  k=j;\
  for(i=0; i<1024; i++) { \
    if(0==close(debug_op[i])) j--; \
  } \
  if(j) perror("close counter != 0"); \
  *X = k; \
}
#else
#define DEB_FDX(X) /* nothing */
#endif

#ifdef DB_FDX
#define COW_CLOSE(FD) {                                             \
    static int x, y, z=0;                                           \
    DEB_FDX(&x)                                                     \
    if (close(FD)) {                                                \
        if (EBADF!=errno) {                                         \
            perror("close");                                        \
            exit(errno);                                            \
        }                                                           \
    } else {                                                        \
        --cow_noof;                                                 \
        z=1;                                                        \
    }                                                               \
    DEB_FDX( &y )                                                   \
    if (x != y - z) {                                               \
        printf("ERROR in COW_CLOSE where x,y = %d, %d\n", x, y);    \
        exit(-1);                                                   \
    }                                                               \
}
#else
#define COW_CLOSE(FD) {                                             \
    if (close(FD)) {                                                \
        if (EBADF != errno) {                                       \
            perror(__FILE__ " :: close");                           \
            exit(errno);                                            \
        }                                                           \
    } else {                                                        \
        --cow_noof;                                                 \
    }                                                               \
}
# endif
// close if fail set errno {EBADF|EINTR}.


#define COW_SEND_R(FD,BUF,RET) {                                    \
    int head=0;                                                     \
    int rem = strlen(BUF);                                          \
    while(0 < (RET = pth_send(FD, BUF+head, rem,0))) {              \
        pth_yield(NULL);                                            \
        head += RET;                                                \
        rem -= RET;                                                 \
        if(1 > rem)                                                 \
            break;                                                  \
    }                                                               \
}

#define COW_SEND_EV(FD,BUF,SEC,USEC) {                              \
    int sent, head=0;                                               \
    int left = strlen(BUF);                                         \
    pth_event_t ev = NULL;                                          \
    ev = pth_event(PTH_EVENT_TIME, pth_timeout(SEC,USEC));          \
    while(0 < (sent = pth_send_ev(FD, BUF+head, left, 0, ev))) {    \
        head += sent; left -= sent;                                 \
        if(0 == left) break;                                        \
        if(0 > sent) break;                                         \
        pth_yield(NULL);                                            \
    }                                                               \
    pth_event_free(ev, PTH_FREE_THIS);                              \
    if(0>sent) return -1;                                           \
}

#define COW_SEND(FD,BUF) COW_SEND_EV(FD,BUF,1,0)

// debug
// there's a way to get some info from kernel on linux, but i don't remember
// off brain.  What about other posix os?
# ifdef DB_FDX
#define DEB_FD \
{ \
  static int debug_op[1024]; \
  static int i,j=0,k; \
  for(i=0; i<1024; i++) { \
    debug_op[i]=open("/dev/null", O_RDONLY); \
    if(debug_op[i]>0) j++; \
  } \
  k=j;printf("(%d)\n",j); \
  for(i=0; i<1024; i++) { \
    if(0==close(debug_op[i])) j--; \
  } \
  if(j) perror("close counter != 0"); \
}
# else
#define DEB_FD  /* nothing */
# endif


#ifdef COWDEBUG
#define PRINT(m)                    printf(m)
#define PRINT1(m,a1)                printf(m,a1);
#define PRINT2(m,a1,a2)             printf(m,a1,a2);
#define PRINT3(m,a1,a2,a3)          printf(m,a1,a2,a3);
#define PRINT4(m,a1,a2,a3,a4)       printf(m,a1,a2,a3,a4);
#define PRINT5(m,a1,a2,a3,a4,a5)    printf(m,a1,a2,a3,a4,a5);
#else
#define PRINT(m)
#define PRINT1(m,a1)
#define PRINT2(m,a1,a2)
#define PRINT3(m,a1,a2,a3)
#define PRINT4(m,a1,a2,a3,a4)
#define PRINT5(m,a1,a2,a3,a4,a5)
#endif
