#include <errno.h>
#include <stdio.h>
#include <stdlib.h>

#include "pth.h"
#include "cow.h"
#include "config.h"
#include "request.h"
#include "http_message.h"
#include "defines.h"            // refers to #define MAXREQLINE 1024

/*
 * The HTTP request handler
 */

void *hand(void *_arg) {
    // pth related vars
    pth_t my_id = (pth_t) NULL;
    char my_name[16];           // 64-bit machine use 16 here? 8 is fine on 32bit pc
    pth_msgport_t depot;
    pth_msgport_t mp;
    pth_event_t ev;
    pmsg pm_msg;
    pmsg *pp_msg;

    // httpd related vars
    int ret_val;
    msg req_msg;

    /*
     * Setup a message port for the current thread so the depot can dispatch
     * requests to us.
     */
    my_id = pth_self();
    sprintf(my_name, "%x", (int)my_id);
    mp = pth_msgport_create(my_name);
    if (mp == NULL) {
        perror("Failed to create message port for handler");
        return NULL;
    }

    /* Wait for the depot's message port to become available */
    while (NULL == (depot = pth_msgport_find(DEPOT)))
        pth_yield(NULL);

    /*
     * Send an initial "request finished" message to the depot.  This will
     * push this handler onto the stack of idle handlers and allow the depot
     * to dispatch requests to us.
     */
    pm_msg.id = my_id;
    pm_msg.mp = mp;
    pm_msg.act = PUSH;
    if (TRUE != pth_msgport_put(depot, (pth_message_t*) &pm_msg)) {
        perror("msgport_put failed in hand initialization");
        exit(1);
    }

    /* Wait for all threads to finish initializing */
    pth_barrier_reach(&init_bar);

    /*
     * Main handler loop; wait for a message on our message port, process the
     * associated HTTP request(s), and then notify the depot that we're done.
     */
    ev = pth_event(PTH_EVENT_MSG, mp);
    for (;;) {
        reqnode* rn;

        /* Wait for a request to be dispatched to us */
        pth_wait(ev);

        /* Get the request message from our message port */
        pp_msg = (pmsg *) pth_msgport_get(mp);
        assert(pp_msg != NULL);

        /* Extract the file descriptor */
        req_msg.fdp = pp_msg->fd;

        /* We're done with the pmsg structure now; return it to the pool */
        rn = (reqnode*)pp_msg;
        rn->next = pmsgpool_first;
        pmsgpool_first = rn;

        /* Read and process the request */
        ret_val = read_request(&req_msg);

        /*
         * Send a message to the depot to put this thread back on the 'idle
         * handler' stack.
         */
        if (TRUE != pth_msgport_push(depot, (pth_message_t *) & pm_msg)) {
            printf("ERROR: msgport_push fialed in hand() initialization. \n");
            exit(-1);
        }
    }

    /* unreachable */
    return _arg;
}

/*
 * handler is per thread spawned for each request.
 * This is still here just for ref or debug purpose.
 */
#if 0
void *handler(void *_arg)
{

    int fd = (int)((long)_arg);
    int msgsize;

    msg req_msg;
    msg *new_req_msg;

    req_msg.fdp = fd;
    msgsize = read_request(&req_msg);
    printf("read_request() returned %d\n", msgsize);

    // to make sure
/*
  { extern int cow_noof;
  COW_CLOSE(req_msg.fdp)
  COW_CLOSE(req_msg.fdd)
  }
*/

    pth_abort(pth_self());
    pth_exit(NULL);
    return (void *)NULL;
}
#endif /* 0 */
