#include <unistd.h>
#include <sys/mman.h>

#include <sys/unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <pth.h>
#include "cow.h"
#include "request.h"
#include "response.h"
#include "mime.h"
#include "utl.h"
#include "cgi.h"
#include "defines.h"
#include "logs.h"

// usually the size of response message headers is 120 bytes,
// with body (e.g. "501 : Requested service ... " is 40 or so.
// Thus 256 is more than enough. (but change it if necessary).
#define HEADS 256
char r100[HEADS];
char r101[HEADS];

char r200[HEADS];
char r201[HEADS];
char r202[HEADS];
char r203[HEADS];
char r204[HEADS];
char r205[HEADS];
char r206[HEADS];

char r300[HEADS];
char r301[HEADS];
char r302[HEADS];
char r303[HEADS];
char r304[HEADS];
char r305[HEADS];
char r306[HEADS];
char r307[HEADS];

char r400[HEADS];
char r401[HEADS];
char r402[HEADS];
char r403[HEADS];
char r404[HEADS];
char r405[HEADS];
char r406[HEADS];
char r407[HEADS];
char r408[HEADS];
char r409[HEADS];
char r410[HEADS];
char r411[HEADS];
char r412[HEADS];
char r413[HEADS];
char r414[HEADS];
char r415[HEADS];
char r416[HEADS];
char r417[HEADS];

char r500[HEADS];
char r501[HEADS];
char r502[HEADS];
char r503[HEADS];
char r504[HEADS];
char r505[HEADS];

/* initialize static reply contents */
/* for now, we use pth version */
#define COW_VERSION PTH_VERSION
#define HTTPV "1.1"
int response_init()
{

#define GEN_HEAD(BUF,STARTLINE,BODY)\
sprintf(BUF,\
"HTTP/" HTTPV " " STARTLINE "\r\n"\
"Server: cow/%x\r\n"\
"Connection: close\r\n"\
"Content-type: text/plain\r\n"\
"Content-Length: %d\r\n"\
"\r\n"\
BODY, COW_VERSION, strlen(BODY));

    GEN_HEAD(r200, "200 OK", "")	// don't use this
	GEN_HEAD(r200, "204 No Content", "204 : Requested file has no content")
	GEN_HEAD(r400, "400 Bad Request", "400 : Bad Request")
	GEN_HEAD(r401, "401 Unauthorized", "401 : Authorization failure")
	GEN_HEAD(r403, "403 Forbidden", "403 : Forbidden")
	GEN_HEAD(r404, "404 Not Found", "404 : Not Found")
	GEN_HEAD(r414, "414 Request-URI Too Long",
		 "414 : Requested URI is too long")
	GEN_HEAD(r500, "500 Internal Server Error",
		 "500 : Internal Server Error")
        GEN_HEAD(r501, "501 Not Implemented",
                 "501 : Requested service is not implemented")
        GEN_HEAD(r503, "503 Service Unavailable",
		 "503 : Requested service is not available") return 0;
}

inline int response_static(int fd, char *str) {
    COW_SEND(fd, str) return 0;
}

inline int response_204(int fd) {
    return response_static(fd, r204);
}
inline int response_400(int fd) {
    return response_static(fd, r400);
}
inline int response_404(int fd) {
    return response_static(fd, r404);
}
inline int response_414(int fd) {
    return response_static(fd, r414);
}
inline int response_500(int fd) {
    return response_static(fd, r500);
}
inline int response_501(int fd) {
    return response_static(fd, r501);
}
inline int response_503(int fd) {
    return response_static(fd, r503);
}
inline int response_default(int fd) {
    return response_static(fd, r503);
}

/* 
put => just put the entity body at specified uri (server takes care it all).
post => pass the entity body to the specified uri (and that uri will take
care of the rest, which is usually cgi
*/
int response_post(msg * req)
{
    return (int)req;
}

int response_put(msg * req)
{
    char *pathname = req->p_pathname;
    struct stat ifstat;
    size_t buf_left;
    size_t tot_left;
    size_t header_len;
/*
printf("++++++++++++++++ PUT start ++++++++++\n\n\n");
*/

    if ((MAX_PATH_LENGTH - strlen(server_root) - 1) <
	(unsigned)(req->p_uri_len)) {
	/* 414 "Request-URI Too Large" */
	response_414(req->fdp);
	return -1;
    }
    pathname[0] = '\0';
    strcat(pathname, server_root);
    strcat(pathname, req->p_uri);
    stat(pathname, &ifstat);

    /* init_get */
    req->fdd = open(pathname, O_WRONLY, 0x666);
    if (-1 == req->fdd) {
#ifdef LOGGING
        fprintf(ELOG, "PUT: Failed to open %s\n", pathname);
#endif
	response_404(req->fdp);
	return -1;
    } else {
	++cow_noof;
    }

/*
  stat (pathname, &ifstat);
  req->r_mimes = get_mime_type (pathname);
  req->r_filesize = ifstat.st_size;

  // request is PUT, and uri found, so compose a header for 200
  req->r_buf[0]='\0';
  compose_header_200(req);	// fix here to add keepalive stuffs

 printf("GOTTTT: %s\n",req->header_line);
*/

// use this
    {
#define xS 2
#define xU 0
/* check the contents */
	if (req->p_entity_body == req->p_buf_head)
//if( '\0' == req->p_entity_body[0] )
	{
	    if ('\0' != req->p_entity_body[0]) {
		printf("first char of eB is (c:d)=(%c:%d)\n",
		       req->p_entity_body[0], (int)req->p_entity_body[0]);
	    }
	    // we don't read anything from the client, so let's read.
	    // we should use "Content-Length", but for now, I just read.
	    {			// sloppy code for now... fix later!
		char BUF[1024] = { '\0' };
		int ReaD;
		int siz = sizeof(BUF);
		pth_event_t ev = NULL;
		ev = pth_event(PTH_EVENT_TIME, pth_timeout(xS, xU));
		while (1) {
		    bzero(BUF, siz);
		    ReaD = -1;
		    ReaD = pth_read_ev(req->fdp, BUF, (size_t) siz, ev);
		    if (ReaD <= 0) {
			printf("\n !!! fuck end !!!\n");
			break;
		    }
		    if (0 > pth_write(req->fdd, BUF, ReaD)
			//pth_write(req->fdd, BUF, strlen(BUF))
			) {
			printf("\n === writing entity body failed ===\n");
			COW_CLOSE(req->fdd) return -1;
		    }
/*
      else
	{
	  printf("\n === writing entity body ===\n");
	  //printf("\n === writing entity body ===\n%s\n===\n",BUF);
	  //pth_sleep(3);
	}
      pth_yield(NULL); 
*/
		    ev = pth_event(PTH_EVENT_TIME, pth_timeout(xS, xU));
		}		// end of while 
		pth_event_free(ev, PTH_FREE_THIS);
		COW_CLOSE(req->fdd) return 0;
	    }

	}
	else {
	    printf(" ???? \n ??? \n ?? \n");	// not yet
	    printf(" -- just to confirm ---\n%s._._.\n", req->p_entity_body);
	    return -1;
	}

    }

// old (and possibly junk. use above block.
    // for now, assume put is small
    if (0 > pth_write(req->fdd, req->header_line, strlen(req->header_line)))
	printf("failed to write\n");

    header_len = strlen(req->r_buf);

    // request is PUT, so just send 200 ok
    buf_left = sizeof(req->r_buf) - header_len;
    tot_left = req->r_filesize - buf_left;

    {
	size_t sent;
	size_t left;
	size_t offset = 0;
	//left = pth_read(req->fdd, header_len + req->r_buf, buf_left); 
	left = 0;
	pth_yield(NULL);
	left += header_len;
	while (left > 0) {
	    sent = pth_send(req->fdp, req->r_buf + offset, left, 0);
            if (sent < 0)
                return -1;
	    pth_yield(NULL);
	}
    }
    return 0;
}

int response_get(msg * req) {
    char *pathname = req->p_pathname;
    struct stat ifstat;
    size_t header_len;

    bzero(req->r_buf, sizeof(req->r_buf));

    if ((MAX_PATH_LENGTH - strlen(server_root) - 1) <
	(unsigned)(req->p_uri_len)) {
	/* 414 "Request-URI Too Large" */
//write(1,&" (414@response_get) ", 20);
	response_414(req->fdp);
	return -1;
    }
    pathname[0] = '\0';
    strcat(pathname, server_root);
    strcat(pathname, req->p_uri);
    stat(pathname, &ifstat);

/* 1 tmp_cgi */
    if (0 == strncmp(req->p_uri, "/cgi-bin", 8) ||
	0 == strncmp(req->p_uri, "cgi-bin", 7)) {
	req->is_cgi = 1;	// revise to CGI or NPH 
    }
/* 1 end of tmp_cgi */

#ifdef HAVE_LIBDMALLOC
    if (0 == strcmp(req->p_uri, "/SHUTDOWN")) {
        fprintf(stderr, "SHUTTING DOWN\n");
        exit(0);
    }
#endif


    if ('/' == pathname[strlen(pathname) - 1])
	strcat(pathname, "index.html");
    else if (S_ISDIR(ifstat.st_mode)) {
	strcat(pathname, "/index.html");
    }

/* 2 tmp_cgi */
/* init_cgi */
    if (req->is_cgi) {
	printf("init_cgi...\n");
	if (-1 == (req->fdd = open(pathname, O_RDONLY | S_IROTH | S_IXOTH))) {
	    perror("open");
	    return -1;
	}
	++cow_noof;
	return tmp_cgi(req);	// see cgi.c
    }
/* 2 end of tmp_cgi */

    /* init_get */
    req->fdd = open(pathname, O_RDONLY);
    if (-1 == req->fdd) {
#ifdef LOGGING
	fprintf(ELOG, "GET: 404 %s (%s)\n", pathname, strerror(errno));
#endif
	//printf("cow_noof is %d\n", cow_noof);
	//write(1,&" (RG 404@response_get) ", 22);
	response_404(req->fdp);
	return -1;
    }
    ++cow_noof;

    stat(pathname, &ifstat);

    req->r_mimes = get_mime_type(pathname);

    if (0 == (req->r_filesize = ifstat.st_size)) {
	return response_204(req->fdp);
    }
    // fix here s.t. proper header (ie. keepalive etc) would be generated.

    // request is GET, and uri found, so compose a header for 200
    req->r_buf[0] = '\0';
    compose_header_200(req);	// add keepalive to this func.

    header_len = strlen(req->r_buf);

    if (M_HEAD == req->p_method) {
	pth_send(req->fdp, req->r_buf, header_len, 0);
	COW_CLOSE(req->fdd);
        return 0;
    }

    /* memory map the file and then send it to the socket */
    {
	ssize_t sent;
	ssize_t left, length;
	ssize_t offset = 0;

//#define MAP_OPTIONS MAP_FILE|MAP_PRIVATE	/* linux */
#define MAP_OPTIONS MAP_FILE|MAP_SHARED
	char *m;
	length = left = req->r_filesize;
	m = mmap(0, left, PROT_READ, MAP_OPTIONS, req->fdd, 0);
	if (NULL == m) {
	    //write(1,&" (500@response_get) ", 20);
	    response_500(req->fdp);
	    COW_CLOSE(req->fdd);
            return -1;
	}

        // send header
        COW_SEND_R(req->fdp, req->r_buf, sent);
        if (0 > sent) {
            COW_CLOSE(req->fdd);
            return -1;
        }

        /* Send the body of the requested page */
        while (left > 0) {
            errno = 0;
            sent = pth_send(req->fdp, m + offset, left, 0);
            if (sent < left && errno && errno != EINTR) {
                /* Some kind of error */
#ifdef LOGGING
                fprintf(ELOG, "Failed to write part of %s to socket; "
                              "already sent %d bytes, remaining were "
                              "not sent.\n",
                              req->p_uri,
                              offset,
                              left);
#endif
                if (munmap(m, length))
                    perror("munmap");
                COW_CLOSE(req->fdd);
                return -1;
            }

            /* Write successful */
            left -= sent;
            offset += sent;

	}

        /* Unmap the file from memory */
	if (munmap(m, length))
	    perror("munmap");
	COW_CLOSE(req->fdd);
    }
    return 0;
}

void compose_header_200(msg * req)
{
    strcat(req->r_buf, "HTTP/1.0 200 OK\r\n");
    add_http_headers(req);
}

// inline
void add_http_headers(msg * req)
{
    char rfc822_time_buf[32];	// ={'\0'};
    char *s;
    struct tm *mytm;
    time_t mytime;

    s = rfc822_time_buf;

    time(&mytime);
    mytm = (struct tm *)gmtime(&mytime);
    // strftime(s, 128, "%a, %d %b %Y %H:%M:%S %Z", mytm);
    // strftime(s, 128, "%a, %d %b %Y %H:%M:%S %z", mytm);
    strftime(s, 128, "%d %b %Y %H:%M %Z", mytm);	// shortest possible
    // printf( "%s\n", s);
    strcat(req->r_buf, "Date: ");
    strcat(req->r_buf, s);
    strcat(req->r_buf, "\r\nServer: Cow/0.01\r\n");

    // print_ka_pharse(req); // not yet
    add_keepalive_lines(req);

    add_content_type(req);
    add_content_length(req);
//add_last_modified(req);

    // end of header.
    strcat(req->r_buf, "\r\n");
}

// inline
void add_content_type(msg * req)
{
    strcat(req->r_buf, "Content-Type: ");
    strcat(req->r_buf, req->r_mimes);
    strcat(req->r_buf, "\r\n");
}

// inline
void add_content_length(msg * req) {
    req = 0;        /* get rid of compiler warning */
/*
  char buf[32]={'\0'};
  strcat(req->r_buf, "Content-Length: ");
  //sprintf(buf, "%lu\r\n\0", (long unsigned)(req->r_filesize));
  sprintf(buf, "%d\r\n\0", (int)(req->r_filesize));
  strcat(req->r_buf, buf);
*/
}

// inline
void add_keepalive_lines(msg * req)
{

/*
  if (req->ka_count >0
  &&  req->ka_status == KA_ACTIVE
  )
//&&  req->response_status < 500)
  {
    char buf_ka_timeout[32];
    char buf_ka_count[32];
    sprintf(buf_ka_timeout, "timeout=%lu, ", ka_max_dur);
    sprintf(buf_ka_count,   "max=%d\r\n", req->ka_count);
    strcat(req->r_buf, "Connection: Keep-Alive\r\nKeep-Alive: timeout=15\r\n");
  }
  else
*/
    req->ka_status = KA_INACTIVE;
    strcat(req->r_buf, "Connection: close\r\n");
}
