#ifndef _COW_H_
#define _COW_H_

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/resource.h>       // setrlimit (2)

#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif /* HAVE_NETINET_IN_H */

#include <netinet/tcp.h> /* for turning off Nagle's algorithm */

#include <arpa/inet.h>
#include <signal.h>
#include <netdb.h>
#include <unistd.h>
#include <fcntl.h>

#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#endif /* HAVE_SYS_TIME_H */

#include <assert.h>

#include <pth.h>

#ifdef HAVE_LIBDMALLOC
#include "dmalloc.h"
#endif

#include "config.h"
#include "cow_config.h"
#include "response.h"
#include "pmsg.h"

extern int cow_nohands;             /* total number of hands */
extern int cow_nohands_running;     /* current number of handlers running */
extern unsigned long cow_max_conn;  /* max simultaneous connections */
extern unsigned long cow_cur_conn;  /* current simultaneous connection */
extern unsigned long cow_tot_parsed; /* total connections completely parsed */
extern unsigned long cow_tot_served; /* total connections completely served */

extern int zero, one;               /* used by setsockopt calls */

extern int server_root_len;         /* string length of server root */

/* pool of pmsg structures */
extern reqnode *pmsgpool, *pmsgpool_first;

extern pth_barrier_t init_bar;      /* initialization barrier structure */
extern pth_t tid_depot;             /* depot's thread id */

#endif /* _COW_H_ */
