#include "config.h"

/*
 * Maximum number of handler threads.  Can be overridden in config file
 * with the NumHands option.
 */
#define COW_NOHAND 16

/*
 * We use pmsg's from a pre-allocated pool to avoid malloc/free overhead.
 * We want to actually allocate a multiple of the number of handler threads
 * we have in order to let the depot queue up some requests.  This constant
 * sets that multiple.  The total size of the pmsg pool will be
 * cow_nohand*POOL_SIZE_FACT.
 */
#define POOL_SIZE_FACT 4

/*
 * Using writev() to combine outgoing buffers should be faster than issuing
 * multiple write()'s.
 */
//#define USE_WRITEV

/*
 * Limiting the number of threads that can be responding over the socket should
 * increase the average transfer speed of each request (although it will
 * obviously increase the amount of time before the first byte is sent back).
 * It is interesting to tune this number and watch the performance impact.
 * Leaving this undefined will allow all threads to send data concurrently.
 */
//#define RESPONSE_CONCURRENCY 1

//#define SOCKETBUF_SIZE                          8192
//#define SOCKETBUF_SIZE                          1024*16 // ok.
//#define SOCKETBUF_SIZE                          1024*64 // ok.
  #define SOCKETBUF_SIZE                          1024*4 // ok.
//#define SOCKETBUF_SIZE                          1024*256 // with *1024
//#define SOCKETBUF_SIZE                          1024*512   // with *1024
//#define SOCKETBUF_SIZE                          1024*1024   // with *2048

#define MAX_HEADER_LEN                          1024
#define MAX_SITENAME_LENGTH                     256

// hand.c only ; for limitting the length of request line.
#define MAXREQLINE 1024

#if defined HAVE_DIRENT_H
#include <dirent.h>             /* for MAXNAMLEN */
#elif defined HAVE_NDIR_H
#include <ndir.h>
#elif defined HAVE_SYS_DIR_H
#include <sys/dir.h>
#elif defined HAVE_SYS_NDIR_H
#include <sys/ndir.h>
#endif

# ifndef MAXNAMLEN
/* Get the definitions of the POSIX.1 limits.  */
#include <limits.h>
/* `MAXNAMLEN' is the BSD name for what POSIX calls `NAME_MAX'.  */
#  ifdef NAME_MAX
#   define MAXNAMLEN    NAME_MAX
#  else
#   define MAXNAMLEN    255
#  endif
# endif

#include <sys/types.h>
#include <sys/socket.h>
#ifndef SO_MAXCONN
#define SO_MAXCONN  128 //default in linux, 64 for bsd
#endif
// ok, here's another test:
//#define SO_MAXCONN COW_NOHAND/2
//#define SOMAXCONN COW_NOHAND/2

#define MAX_PATH_LENGTH                         NAME_MAX
#define MAX_REQ_URI_LEN                         256
#define MAX_URI_LEN                             MAX_PATH_LENGTH
#define MAX_BUF_SIZE                            SOCKETBUF_SIZE
#define MIME_TYPE_LEN                           32

/*********** KEEPALIVE CONSTANTS (req->keepalive) *******/
#define KA_INACTIVE     0
#define KA_STOPPED      1
#define KA_ACTIVE       2

#define KA_MAX_CON     16       /* max number of ka connection */
#define KA_MAX_DUR     10       /* max seconds of ka duration */

/* default values for port operations */
#define COW_RTO_S      15       /* recv or read from port TimeOut value (sec)*/
#define COW_RTO_U       0       /* recv or read from port TimeOut value (usec)*/
/* currently not used (do we need these?) */
#define COW_WTO_S       0       /* same for write or send (but probably */
#define COW_WTO_U    1000       /* not needed cuz write error -> immediate -1 */

#define COW_CLOSE(FD) {                                             \
    if (close(FD)) {                                                \
        if (EBADF != errno) {                                       \
            perror(__FILE__ " :: close");                           \
            exit(errno);                                            \
        }                                                           \
    } else {                                                        \
        --cow_noof;                                                 \
    }                                                               \
}

#ifdef USE_TCPCORK
#define SOCKTYPE int
#else
#define SOCKTYPE BUFF*
#endif

#ifdef LOGGING
#define LOG(l,m)        fprintf(l, m)
#define LOG1(l,m,a1)    fprintf(l, m, a1)
#define LOG2(l,m,a1,a2) fprintf(l, m, a1, a2)
#else
#define LOG(l,m)
#define LOG1(l,m,a1)
#define LOG2(l,m,a1,a2)
#endif

#ifdef COWDEBUG
#define PRINT(m)                    printf(m)
#define PRINT1(m,a1)                printf(m,a1);
#define PRINT2(m,a1,a2)             printf(m,a1,a2);
#define PRINT3(m,a1,a2,a3)          printf(m,a1,a2,a3);
#define PRINT4(m,a1,a2,a3,a4)       printf(m,a1,a2,a3,a4);
#define PRINT5(m,a1,a2,a3,a4,a5)    printf(m,a1,a2,a3,a4,a5);
#else
#define PRINT(m)
#define PRINT1(m,a1)
#define PRINT2(m,a1,a2)
#define PRINT3(m,a1,a2,a3)
#define PRINT4(m,a1,a2,a3,a4)
#define PRINT5(m,a1,a2,a3,a4,a5)
#endif
