#ifndef HTTP_MESSAGE_H
#define HTTP_MESSAGE_H

#include "defines.h"
#include "buff.h"

typedef
struct http_message {
    int fdd;            /* data fd */
#ifdef USE_TCPCORK
    int fdp;            /* port fd *  (i.e. pending request) */
#else
    BUFF* fdp;          /* Transaction I/O buffer */
#endif

    int simple;         /* simple request (i.e. no HTTP/x.y on request line) */
    int ka_status;      /* keepalive status; see defines.h */
    int ka_count;       /* keepalive count */
    time_t ka_timeout;  /* when ka expires */

    char* http_version;
    int hv_major;
    int hv_minor;

    /* p_ for association with port fd (pending request) */
    char* p_header_end;
    char* p_pos;
    int p_uri_len;
    //char* p_uri_begin;
    //char* p_uri_end;
    char  p_uri[ MAX_REQ_URI_LEN+1 ];
    char  p_pathname[ MAX_PATH_LENGTH ];
    char  p_buf[ MAX_BUF_SIZE ];
    int   p_method;       /* enum method */
    char* p_buf_head;     /* begin of unused buffer portion */
    int   p_buf_left;     /* bytes of buf left for reading the request */
    int   p_buf_read;     /* return val of each recv */
    char* p_entity_body;  /* begin of the entity body */
    // probably not needed. rm later.
    int   p_eof;          /* if [pth_]read/recv returned 0, set this to 1 */

    /* r_ for reply message */
    char *r_mimes;
    unsigned long r_filesize;

    int status;

    int filetype;

    /* header options */
    char *if_modified_since;    /* If-Modified-Since */
    time_t last_modified;       /* Last-modified: */

    char *content_type;
    char *content_length;
    int is_cgi;

    char *header_user_agent;
    char *header_referer;
    char *header_line;    // added

} msg;

enum Method {
    M_OPTIONS,
    M_GET,
    M_HEAD,
    M_POST,
    M_PUT,
    M_DELETE,
    M_TRACE,
    M_CONNECT,
    M_EXTENTION
};

enum ReqStatus {
    START_LINE,
    NO_CRLF,
    ONE_CRLF,
    TWO_CRLF,
    BODY_WRITE,
    BODY_READ,
    DONE,
    DEAD
};

enum FileType {
    HTML,
    TXT,
    DATA
};

# endif /* HTTP_MESSAGE_H */
