#include <ctype.h>		// man 3 toupper
#include "cow.h"
#include "utl.h"
#include "http_message.h"

void filetype(msg * req)
{
    char *pathname = req->p_pathname;
    int i = strlen(pathname) - 1;

    // for now, we simply assume the suffix is correct.
    // Also, we handle .html and .txt only

    if (('l' == pathname[i]) &&
	('m' == pathname[i - 1]) &&
	('t' == pathname[i - 2]) &&
	('h' == pathname[i - 3]) && ('.' == pathname[i - 4])) {
	req->filetype = HTML;
	return;
    }
    if (('t' == pathname[i]) &&
	('x' == pathname[i - 1]) &&
	('t' == pathname[i - 2]) && ('.' == pathname[i - 3])) {
	req->filetype = TXT;
	return;
    }
    req->filetype = DATA;
    return;
}

/* 
 * consume space, tab, cr, lf
 * return the vlue read.
 */
int eat_ws(FILE * fp)
{
    int head;
    for (;;) {
	head = getc(fp);
	if ('#' == head) {
	    eat_line(fp);
	    head = getc(fp);
	}
	if ((' ' != head) && ('\t' != head) && ('\n' != head) && ('\r' != head))
	    return head;
    }
}

/*
 * consume a line (e.g. for comment lines beginning w/ #)
 */
void eat_line(FILE * fp)
{
    int head;
    for (;;) {
	head = getc(fp);
	if (('\n' == head) || ('\r' == head) || ('\0' == head))
	    return;
    }
}

/*
char* 
get_mime_type ( FILE* fp )
{
}
*/

/*
 * Name: to_upper
 *
 * Description: Turns a string into all upper case (for HTTP_ header forming)
 * AND changes - into _
 */

char *to_upper(char *str)
{
    char *start = str;

    while (*str) {
	if (*str == '-')
	    *str = '_';
	else
	    *str = toupper(*str);

	str++;
    }

    return start;
}

/* simple int to ascii (from boa) */
char *simple_itoa(int i)
{
    static char local[22];
    char *p = &local[21];
    do {
	*p-- = '0' + i % 10;
	i /= 10;
    }
    while (i > 0);
    return p + 1;
}
