#include "ast.h"
#include "control.h"
#include "symbol.h"
#include <vector>
#include <iostream>
using namespace std;

#define cout cout
#define Coutput cout

extern "C" {
  void callIt();
  void FindTemplateMethod(DelegationTable*); 
}

void callIt()
{
  Coutput << endl << "User-defined Patterns:" << endl;
}

void FindTemplateMethod(DelegationTable *d_table)
{
  Coutput << "In user-defined FindTemplatemethod" << endl;
  vector<TypeSymbol*> cache;
  for (int i = 0; i < d_table -> size(); i++)
    {
      DelegationEntry* entry = d_table -> Entry(i);	
/*
  if (strcmp(entry -> method -> Utf8Name(), "handleConnect") == 0)
  entry->method->declaration->MethodDeclarationCast()->Print();
  
  if (strcmp(entry -> method -> Utf8Name(), "target") == 0)
  entry->method->declaration->MethodDeclarationCast()->Print();
*/
      unsigned j = 0;
      for (; (j < cache.size()) && (cache[j] != entry -> from) ; j++);
      if (j == cache.size())
	{
	  if ((entry -> enclosing -> containing_type == entry -> method -> containing_type)
		&& entry -> enclosing -> ACC_PUBLIC()
	      	//&& entry -> method -> ACC_PROTECTED()
	      	&& (entry -> enclosing -> declaration -> kind == Ast::METHOD)
	      	&& (entry -> method -> declaration -> kind == Ast::METHOD)
	      	&& (entry -> from == entry -> to))
	    {
	      AstMethodDeclaration* method_declaration = entry -> method -> declaration -> MethodDeclarationCast();
	      if (entry -> method -> ACC_ABSTRACT()
		  || (method_declaration -> method_body_opt == 0)
		  || ((method_declaration -> method_body_opt -> Statement(0) -> kind == Ast::RETURN) 
		      && (method_declaration -> method_body_opt -> Statement(0) -> ReturnStatementCast() -> expression_opt == 0 ))
		  )
		{
		  //nTemplate++;
		  cache.push_back(entry -> from);
		  Coutput << "Template Method Found." << endl;
		  Coutput << entry -> from -> Utf8Name() << " is the template class" << endl;
		  Coutput << entry -> enclosing -> Utf8Name() << " is the template method" << endl;
		  Coutput << entry -> method -> Utf8Name() << " is a primitive method" << endl;			
		  //Coutput << "File Location: " << entry -> from -> file_symbol -> FileName() << endl << endl;
		}
	    }
	}
    }
}
