/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.util;

import com.sun.corba.se.internal.util.IdentityHashtableEntry;
import com.sun.corba.se.internal.util.IdentityHashtableEnumerator;
import java.util.Dictionary;
import java.util.Enumeration;

public final class IdentityHashtable
extends Dictionary {
    private transient IdentityHashtableEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public int size() {
        return this.count;
    }

    public IdentityHashtable() {
        this(101, 0.75f);
    }

    public void clear() {
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n2 = identityHashtableEntryArray.length;
        while (--n2 >= 0) {
            identityHashtableEntryArray[n2] = null;
        }
        this.count = 0;
    }

    protected void rehash() {
        int n2 = this.table.length;
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n3 = n2 * 2 + 1;
        IdentityHashtableEntry[] identityHashtableEntryArray2 = new IdentityHashtableEntry[n3];
        this.threshold = (int)((float)n3 * this.loadFactor);
        this.table = identityHashtableEntryArray2;
        int n4 = n2;
        while (n4-- > 0) {
            IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n4];
            while (identityHashtableEntry != null) {
                IdentityHashtableEntry identityHashtableEntry2 = identityHashtableEntry;
                identityHashtableEntry = identityHashtableEntry.next;
                int n5 = (identityHashtableEntry2.hash & Integer.MAX_VALUE) % n3;
                identityHashtableEntry2.next = identityHashtableEntryArray2[n5];
                identityHashtableEntryArray2[n5] = identityHashtableEntry2;
            }
        }
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public IdentityHashtable(int n2) {
        this(n2, 0.75f);
    }

    public IdentityHashtable(int n2, float f2) {
        if (n2 <= 0 || (double)f2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f2;
        this.table = new IdentityHashtableEntry[n2];
        this.threshold = (int)((float)n2 * f2);
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n2 = identityHashtableEntryArray.length;
        while (n2-- > 0) {
            IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n2];
            while (identityHashtableEntry != null) {
                if (identityHashtableEntry.value == object) {
                    return true;
                }
                identityHashtableEntry = identityHashtableEntry.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n2 = System.identityHashCode(object);
        int n3 = (n2 & Integer.MAX_VALUE) % identityHashtableEntryArray.length;
        IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n3];
        while (identityHashtableEntry != null) {
            if (identityHashtableEntry.hash == n2 && identityHashtableEntry.key == object) {
                return true;
            }
            identityHashtableEntry = identityHashtableEntry.next;
        }
        return false;
    }

    public String toString() {
        int n2 = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        for (int i2 = 0; i2 <= n2; ++i2) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(string + "=" + string2);
            if (i2 >= n2) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public Enumeration elements() {
        return new IdentityHashtableEnumerator(this.table, false);
    }

    public Enumeration keys() {
        return new IdentityHashtableEnumerator(this.table, true);
    }

    public Object get(Object object) {
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n2 = System.identityHashCode(object);
        int n3 = (n2 & Integer.MAX_VALUE) % identityHashtableEntryArray.length;
        IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n3];
        while (identityHashtableEntry != null) {
            if (identityHashtableEntry.hash == n2 && identityHashtableEntry.key == object) {
                return identityHashtableEntry.value;
            }
            identityHashtableEntry = identityHashtableEntry.next;
        }
        return null;
    }

    public Object remove(Object object) {
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n2 = System.identityHashCode(object);
        int n3 = (n2 & Integer.MAX_VALUE) % identityHashtableEntryArray.length;
        IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n3];
        IdentityHashtableEntry identityHashtableEntry2 = null;
        while (identityHashtableEntry != null) {
            if (identityHashtableEntry.hash == n2 && identityHashtableEntry.key == object) {
                if (identityHashtableEntry2 != null) {
                    identityHashtableEntry2.next = identityHashtableEntry.next;
                } else {
                    identityHashtableEntryArray[n3] = identityHashtableEntry.next;
                }
                --this.count;
                return identityHashtableEntry.value;
            }
            identityHashtableEntry2 = identityHashtableEntry;
            identityHashtableEntry = identityHashtableEntry.next;
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        IdentityHashtableEntry[] identityHashtableEntryArray = this.table;
        int n2 = System.identityHashCode(object);
        int n3 = (n2 & Integer.MAX_VALUE) % identityHashtableEntryArray.length;
        IdentityHashtableEntry identityHashtableEntry = identityHashtableEntryArray[n3];
        while (identityHashtableEntry != null) {
            if (identityHashtableEntry.hash == n2 && identityHashtableEntry.key == object) {
                Object object3 = identityHashtableEntry.value;
                identityHashtableEntry.value = object2;
                return object3;
            }
            identityHashtableEntry = identityHashtableEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(object, object2);
        }
        identityHashtableEntry = new IdentityHashtableEntry();
        identityHashtableEntry.hash = n2;
        identityHashtableEntry.key = object;
        identityHashtableEntry.value = object2;
        identityHashtableEntry.next = identityHashtableEntryArray[n3];
        identityHashtableEntryArray[n3] = identityHashtableEntry;
        ++this.count;
        return null;
    }
}

