/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.ColorType;
import java.awt.Color;
import javax.swing.plaf.ColorUIResource;

class GTKColorType
extends ColorType {
    public static final ColorType LIGHT = new GTKColorType("Light");
    public static final ColorType DARK = new GTKColorType("Dark");
    public static final ColorType MID = new GTKColorType("Mid");
    public static final ColorType BLACK = new GTKColorType("Black");
    public static final ColorType WHITE = new GTKColorType("White");
    public static final int MAX_COUNT;
    private static final float[] HLS_COLORS;
    private static final Object HLS_COLOR_LOCK;

    static {
        HLS_COLORS = new float[3];
        HLS_COLOR_LOCK = new Object();
        MAX_COUNT = WHITE.getID() + 1;
    }

    private static float hlsValue(float f2, float f3, float f4) {
        if (f4 > 360.0f) {
            f4 -= 360.0f;
        } else if (f4 < 0.0f) {
            f4 += 360.0f;
        }
        if (f4 < 60.0f) {
            return f2 + (f3 - f2) * f4 / 60.0f;
        }
        if (f4 < 180.0f) {
            return f3;
        }
        if (f4 < 240.0f) {
            return f2 + (f3 - f2) * (240.0f - f4) / 60.0f;
        }
        return f2;
    }

    private static int hlsToRGB(float f2, float f3, float f4) {
        float f5;
        float f6;
        float f7;
        float f8 = f3 <= 0.5f ? f3 * (1.0f + f4) : f3 + f4 - f3 * f4;
        float f9 = 2.0f * f3 - f8;
        if ((double)f4 == 0.0) {
            if ((double)f2 == 0.0) {
                f6 = f7 = f3;
                f5 = f7;
            } else {
                f7 = 0.0f;
                f6 = 0.0f;
                f5 = 0.0f;
            }
        } else {
            f5 = GTKColorType.hlsValue(f9, f8, f2 + 120.0f);
            f6 = GTKColorType.hlsValue(f9, f8, f2);
            f7 = GTKColorType.hlsValue(f9, f8, f2 - 120.0f);
        }
        return (int)(f5 * 255.0f) << 16 | (int)((double)f6 * 255.0) << 8 | (int)(f7 * 255.0f);
    }

    private static float[] rgbToHLS(int n2, float[] fArray) {
        float f2 = (float)((n2 & 0xFF0000) >> 16) / 255.0f;
        float f3 = (float)((n2 & 0xFF00) >> 8) / 255.0f;
        float f4 = (float)(n2 & 0xFF) / 255.0f;
        float f5 = Math.max(Math.max(f2, f3), f4);
        float f6 = Math.min(Math.min(f2, f3), f4);
        float f7 = (f5 + f6) / 2.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        if (f5 != f6) {
            float f10 = f5 - f6;
            float f11 = f8 = f7 <= 0.5f ? f10 / (f5 + f6) : f10 / (2.0f - f5 - f6);
            f9 = f2 == f5 ? (f3 - f4) / f10 : (f3 == f5 ? 2.0f + (f4 - f2) / f10 : 4.0f + (f2 - f3) / f10);
            if ((f9 *= 60.0f) < 0.0f) {
                f9 += 360.0f;
            }
        }
        if (fArray == null) {
            fArray = new float[]{f9, f7, f8};
        }
        return fArray;
    }

    protected GTKColorType(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Color adjustColor(Color color, float f2, float f3, float f4) {
        float f5;
        float f6;
        float f7;
        Object object = HLS_COLOR_LOCK;
        synchronized (object) {
            float[] fArray = GTKColorType.rgbToHLS(color.getRGB(), HLS_COLORS);
            f7 = fArray[0];
            f6 = fArray[1];
            f5 = fArray[2];
        }
        f7 = Math.min(360.0f, f2 * f7);
        f6 = Math.min(1.0f, f3 * f6);
        f5 = Math.min(1.0f, f4 * f5);
        return new ColorUIResource(GTKColorType.hlsToRGB(f7, f6, f5));
    }
}

