/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Shape;
import java.awt.peer.MenuBarPeer;
import sun.awt.X11GraphicsConfig;
import sun.awt.motif.MFramePeer;
import sun.awt.motif.MMenuItemPeer;
import sun.awt.motif.MToolkit;
import sun.awt.motif.MWindowAttributes;
import sun.awt.motif.MWindowPeer;

public class MMenuBarPeer
implements MenuBarPeer {
    long pData;
    MenuBar target;
    private X11GraphicsConfig graphicsConfig = null;
    private boolean disposed = false;
    static final int GAP = 10;
    static final int W_DIFF = 12;
    static final int H_DIFF = 23;

    static {
        MMenuBarPeer.initIDs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        boolean bl2 = false;
        if (!this.disposed) {
            MMenuBarPeer mMenuBarPeer = this;
            synchronized (mMenuBarPeer) {
                if (!this.disposed) {
                    bl2 = true;
                    this.disposed = true;
                }
            }
        }
        if (bl2) {
            this.disposeImpl();
        }
    }

    protected void disposeImpl() {
        MToolkit.targetDisposedPeer(this.target, this);
        this.pDispose();
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private static native void initIDs();

    private native void pDispose();

    public void delMenu(int n2) {
    }

    void print(Graphics graphics) {
        Object object;
        MenuBar menuBar = this.target;
        Frame frame = (Frame)MMenuItemPeer.getParent_NoClientCode(this.target);
        Dimension dimension = frame.size();
        Insets insets = frame.insets();
        int n2 = dimension.width;
        int n3 = insets.top;
        if (frame.getPeer() instanceof MFramePeer) {
            object = (MFramePeer)frame.getPeer();
            if (((MWindowPeer)object).hasDecorations(MWindowAttributes.AWT_DECOR_BORDER)) {
                n2 -= 12;
                n3 -= 6;
            }
            if (((MWindowPeer)object).hasDecorations(MWindowAttributes.AWT_DECOR_MENU)) {
                n3 -= 17;
            }
        }
        object = new Dimension(n2, n3);
        Shape shape = graphics.getClip();
        graphics.clipRect(0, 0, ((Dimension)object).width, ((Dimension)object).height);
        Color color = frame.getBackground();
        Color color2 = frame.getForeground();
        Color color3 = color.brighter();
        Color color4 = color.darker();
        if (color3.equals(Color.white)) {
            graphics.setColor(new Color(230, 230, 230));
        } else {
            graphics.setColor(color3);
        }
        graphics.drawLine(0, 0, ((Dimension)object).width, 0);
        graphics.drawLine(1, 1, ((Dimension)object).width - 1, 1);
        graphics.drawLine(0, 0, 0, ((Dimension)object).height);
        graphics.drawLine(1, 1, 1, ((Dimension)object).height - 1);
        graphics.setColor(color4);
        graphics.drawLine(((Dimension)object).width, 1, ((Dimension)object).width, ((Dimension)object).height);
        graphics.drawLine(((Dimension)object).width - 1, 2, ((Dimension)object).width - 1, ((Dimension)object).height);
        graphics.drawLine(1, ((Dimension)object).height, ((Dimension)object).width, ((Dimension)object).height);
        graphics.drawLine(2, ((Dimension)object).height - 1, ((Dimension)object).width, ((Dimension)object).height - 1);
        int n4 = 10;
        int n5 = menuBar.countMenus();
        Menu menu = this.target.getHelpMenu();
        for (int i2 = 0; i2 < n5; ++i2) {
            Menu menu2 = this.target.getMenu(i2);
            String string = menu2.getLabel();
            if (string == null) {
                string = "";
            }
            Font font = menu2.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n6 = ((Dimension)object).height / 2 + fontMetrics.getMaxDescent();
            int n7 = fontMetrics.stringWidth(string) + 20;
            if (n4 >= ((Dimension)object).width) break;
            if (menu2.isEnabled()) {
                graphics.setColor(color2);
            } else {
                graphics.setColor(color4);
            }
            if (menu == menu2) {
                graphics.drawString(string, ((Dimension)object).width - n7 + 10, n6);
                continue;
            }
            graphics.drawString(string, n4, n6);
            n4 += n7;
        }
        graphics.setClip(shape);
    }

    public void addHelpMenu(Menu menu) {
    }

    public void addMenu(Menu menu) {
    }

    public MMenuBarPeer(MenuBar menuBar) {
        this.target = menuBar;
        MFramePeer mFramePeer = (MFramePeer)MToolkit.targetToPeer(MMenuItemPeer.getParent_NoClientCode(menuBar));
        this.create(mFramePeer);
    }

    native void create(MFramePeer var1);
}

