/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.cert.CRLException;
import java.security.cert.CRLSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import sun.security.action.GetPropertyAction;
import sun.security.util.Cache;
import sun.security.util.Debug;
import sun.security.x509.CRLDistributionPointsExtension;
import sun.security.x509.DistributionPoint;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNames;
import sun.security.x509.URIName;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

class DistributionPointFetcher {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final boolean USE_CRLDP = DistributionPointFetcher.getBooleanProperty("com.sun.security.enableCRLDP", false);
    private static final DistributionPointFetcher INSTANCE = new DistributionPointFetcher();
    private static final int CHECK_INTERVAL = 30000;
    private static final int CACHE_SIZE = 185;
    private final CertificateFactory factory;
    private final Cache cache;

    private DistributionPointFetcher() {
        try {
            this.factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException();
        }
        this.cache = Cache.newSoftMemoryCache(185);
    }

    public static boolean getBooleanProperty(String string, boolean bl2) {
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction(string));
        if (string2 == null) {
            return bl2;
        }
        if (string2.equalsIgnoreCase("false")) {
            return false;
        }
        if (string2.equalsIgnoreCase("true")) {
            return true;
        }
        throw new RuntimeException("Value of " + string + " must either be 'true' or 'false'");
    }

    static DistributionPointFetcher getInstance() {
        return INSTANCE;
    }

    static /* synthetic */ Debug access$000() {
        return debug;
    }

    Collection getCRLs(CRLSelector cRLSelector) throws CertStoreException {
        if (!USE_CRLDP) {
            return Collections.EMPTY_SET;
        }
        if (!(cRLSelector instanceof X509CRLSelector)) {
            return Collections.EMPTY_SET;
        }
        X509CRLSelector x509CRLSelector = (X509CRLSelector)cRLSelector;
        X509Certificate x509Certificate = x509CRLSelector.getCertificateChecking();
        if (x509Certificate == null) {
            return Collections.EMPTY_SET;
        }
        try {
            CRLDistributionPointsExtension cRLDistributionPointsExtension;
            X509CertImpl x509CertImpl = X509CertImpl.toImpl(x509Certificate);
            if (debug != null) {
                debug.println("Checking CRLDPs for " + x509CertImpl.getSubjectX500Principal());
            }
            if ((cRLDistributionPointsExtension = x509CertImpl.getCRLDistributionPointsExtension()) == null) {
                return Collections.EMPTY_SET;
            }
            X500Name x500Name = (X500Name)x509CertImpl.getIssuerDN();
            List list = (List)cRLDistributionPointsExtension.get("points");
            HashSet hashSet = new HashSet();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DistributionPoint distributionPoint = (DistributionPoint)iterator.next();
                Collection collection = this.getCRLs(x509CRLSelector, x500Name, distributionPoint);
                hashSet.addAll(collection);
            }
            if (debug != null) {
                debug.println("Returning " + hashSet.size() + " CRLs");
            }
            return hashSet;
        }
        catch (CertificateException certificateException) {
            return Collections.EMPTY_SET;
        }
        catch (IOException iOException) {
            return Collections.EMPTY_SET;
        }
    }

    private Collection getCRLs(X509CRLSelector x509CRLSelector, X500Name x500Name, DistributionPoint distributionPoint) {
        Object object;
        Object object2;
        if (distributionPoint.getReasonFlags() != null) {
            return Collections.EMPTY_LIST;
        }
        GeneralNames generalNames = distributionPoint.getCRLIssuer();
        if (generalNames != null) {
            object2 = generalNames.iterator();
            while (object2.hasNext()) {
                object = ((GeneralName)object2.next()).getName();
                if (x500Name.equals(object)) continue;
                return Collections.EMPTY_LIST;
            }
        }
        if ((object2 = distributionPoint.getFullName()) == null) {
            return Collections.EMPTY_LIST;
        }
        object = new ArrayList(2);
        Iterator iterator = ((GeneralNames)object2).iterator();
        while (iterator.hasNext()) {
            GeneralName generalName = (GeneralName)iterator.next();
            if (generalName.getType() != 6) continue;
            URIName uRIName = (URIName)generalName.getName();
            String string = uRIName.getName();
            if (debug != null) {
                debug.println("Trying to fetch CRL from DP " + string);
            }
            try {
                X509CRL x509CRL;
                URI uRI = new URI(string);
                if (uRI.getScheme().toLowerCase().equals("ldap")) continue;
                CacheEntry cacheEntry = (CacheEntry)this.cache.get(uRI);
                if (cacheEntry == null) {
                    cacheEntry = new CacheEntry();
                    this.cache.put(uRI, cacheEntry);
                }
                if ((x509CRL = cacheEntry.getCRL(this.factory, uRI)) == null || !x509CRLSelector.match(x509CRL)) continue;
                object.add(x509CRL);
            }
            catch (URISyntaxException uRISyntaxException) {
                if (debug == null) continue;
                debug.println("Exception parsing URI:");
                uRISyntaxException.printStackTrace();
            }
        }
        return object;
    }

    private static class CacheEntry {
        private X509CRL crl;
        private long lastChecked;
        private long lastModified;

        CacheEntry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        synchronized X509CRL getCRL(CertificateFactory var1_1, URI var2_2) {
            block27: {
                block26: {
                    block25: {
                        block24: {
                            var3_3 = System.currentTimeMillis();
                            if (var3_3 - this.lastChecked < 30000L) {
                                if (DistributionPointFetcher.access$000() == null) return this.crl;
                                DistributionPointFetcher.access$000().println("Returning CRL from cache");
                                return this.crl;
                            }
                            this.lastChecked = var3_3;
                            var5_4 = null;
                            try {
                                try {
                                    var6_5 = var2_2.toURL();
                                    var7_8 = var6_5.openConnection();
                                    if (this.lastModified != 0L) {
                                        var7_8.setIfModifiedSince(this.lastModified);
                                    }
                                    var5_4 = var7_8.getInputStream();
                                    var8_9 = this.lastModified;
                                    this.lastModified = var7_8.getLastModified();
                                    if (var8_9 != 0L) {
                                        if (var8_9 == this.lastModified) {
                                            if (DistributionPointFetcher.access$000() != null) {
                                                DistributionPointFetcher.access$000().println("Not modified, using cached copy");
                                            }
                                            var10_10 = this.crl;
                                            var13_12 = null;
                                            if (var5_4 == null) return var10_10;
                                            break block24;
                                        }
                                        if (var7_8 instanceof HttpURLConnection && (var10_11 = (HttpURLConnection)var7_8).getResponseCode() == 304) {
                                            if (DistributionPointFetcher.access$000() != null) {
                                                DistributionPointFetcher.access$000().println("Not modified, using cached copy");
                                            }
                                            var11_24 = this.crl;
                                            break block25;
                                        }
                                    }
                                    if (DistributionPointFetcher.access$000() != null) {
                                        DistributionPointFetcher.access$000().println("Downloading new CRL...");
                                    }
                                    this.crl = (X509CRL)var1_1.generateCRL(var5_4);
                                    var10_11 = this.crl;
                                    break block26;
                                }
                                catch (IOException var6_6) {
                                    if (DistributionPointFetcher.access$000() != null) {
                                        DistributionPointFetcher.access$000().println("Exception fetching CRLDP:");
                                        var6_6.printStackTrace();
                                    }
                                    var13_15 = null;
                                    if (var5_4 != null) {
                                        try {
                                            var5_4.close();
                                        }
                                        catch (IOException var14_21) {}
                                    }
                                    break block27;
                                }
                                catch (CRLException var6_7) {
                                    if (DistributionPointFetcher.access$000() != null) {
                                        DistributionPointFetcher.access$000().println("Exception fetching CRLDP:");
                                        var6_7.printStackTrace();
                                    }
                                    var13_16 = null;
                                    if (var5_4 == null) break block27;
                                    try {}
                                    catch (IOException var14_22) {}
                                    var5_4.close();
                                    break block27;
                                }
                            }
                            catch (Throwable var12_25) {
                                var13_17 = null;
                                if (var5_4 == null) throw var12_25;
                                ** try [egrp 2[TRYBLOCK] [12 : 300->308)] { 
lbl67:
                                // 1 sources

                                var5_4.close();
                                throw var12_25;
lbl69:
                                // 1 sources

                                catch (IOException var14_23) {
                                    // empty catch block
                                }
                                throw var12_25;
                            }
                        }
                        ** try [egrp 2[TRYBLOCK] [12 : 300->308)] { 
lbl74:
                        // 1 sources

                        var5_4.close();
                        return var10_10;
lbl76:
                        // 1 sources

                        catch (IOException var14_18) {
                            // empty catch block
                        }
                        return var10_10;
                    }
                    var13_13 = null;
                    if (var5_4 == null) return var11_24;
                    ** try [egrp 2[TRYBLOCK] [12 : 300->308)] { 
lbl83:
                    // 1 sources

                    var5_4.close();
                    return var11_24;
lbl85:
                    // 1 sources

                    catch (IOException var14_19) {
                        // empty catch block
                    }
                    return var11_24;
                }
                var13_14 = null;
                if (var5_4 == null) return var10_11;
                try {}
                catch (IOException var14_20) {
                    // empty catch block
                    return var10_11;
                }
                var5_4.close();
                return var10_11;
            }
            this.lastModified = 0L;
            this.crl = null;
            return null;
        }
    }
}

